// (C) 2005 Max Howell (max.howell@methylblue.com)
// See COPYING file for licensing information

#include <kpushbutton.h>
#include <tqapplication.h>
#include <tqevent.h>
#include "toolbar.h"


MouseOverToolBar::MouseOverToolBar( TQWidget *parent )
      : TDEToolBar( parent )
{
   parent->installEventFilter( this );
   move( 0, 0 ); //TODO necessary?
   hide();

   setPalette( TQApplication::palette() ); //videoWindow palette has a black background
}

bool
MouseOverToolBar::eventFilter( TQObject *o, TQEvent *e )
{
   Q_ASSERT( o == parent() );

   switch( e->type() )
   {
   case TQEvent::Resize:
      resize( static_cast<TQResizeEvent*>(e)->size().width(), sizeHint().height() );
      break;

   case TQEvent::Enter:
      show();
      break;

   case TQEvent::Leave:
      hide();
      break;

   default:
      ;
   }

   return false;
}
