/***************************************************************************
 *   Copyright (C) 2004-2007 by Georgy Yunaev, gyunaev@ulduzsoft.com       *
 *   Please do not use email address above for bug reports; see            *
 *   the README file                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef ICON_STORAGE_H
#define ICON_STORAGE_H

#include <tqmap.h>
#include <tqpixmap.h>


class KCHMIconStorage
{
	public:
		typedef struct
		{
			unsigned int 	size;
			const char * 	data;
		} png_memory_image_t;

		enum pixmap_index_t
		{
			back = 1000,
			bookmark_add,
			fileopen,
			print,
			findnext,
			findprev,
			forward,
			gohome,
			viewsource,
			view_decrease,
			view_increase,
			next_page,
			prev_page,
			locate_in_content
		};
	
		KCHMIconStorage();
		const TQPixmap * getToolbarPixmap (pixmap_index_t pix);
		const TQPixmap * getApplicationIcon();
		const TQPixmap * getCloseWindowIcon();
	
	private:
		const TQPixmap * returnOrLoadImage (unsigned int id, const png_memory_image_t * image);
	
		TQMap<unsigned int, TQPixmap*>	m_iconMap;
		TQPixmap *						m_iconApplication;
		TQPixmap *						m_iconCloseWindow;
};

extern KCHMIconStorage	gIconStorage;

#endif /* ICON_STORAGE_H */
