###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### Make sure at least a DB backend is selected

if ( NOT WITH_MYSQL AND NOT WITH_POSTGRESQL AND NOT WITH_SQLITE3 )
  tde_message_fatal( "No DB backend selected. Building cannot continue" )
endif( )


#### check for MySQL or MariaDB

if( WITH_MYSQL )

  message( STATUS "Check for MariaDB or MySQL" )
  find_program( MYSQL_CONFIG NAMES mariadb_config mysql_config )
  if( NOT MYSQL_CONFIG )
    tde_message_fatal( "MySQL support was requested but neither MySQL nor MariaDB have been found on your system" )
  endif()

  macro( _mysql_config  __type __var )
    execute_process(
      COMMAND ${MYSQL_CONFIG} --${__type}
      OUTPUT_VARIABLE ${__var}
      RESULT_VARIABLE __result
      OUTPUT_STRIP_TRAILING_WHITESPACE )
    if( _result )
      tde_message_fatal( "Unable to run ${MYSQL_CONFIG}!" )
    endif()
  endmacro()

  _mysql_config( include MYSQL_INCLUDE_DIRS )
  _mysql_config( libs    MYSQL_LIBRARIES    )

  if( MYSQL_INCLUDE_DIRS )
    string( REGEX REPLACE "(^| +)-I" ";" MYSQL_INCLUDE_DIRS "${MYSQL_INCLUDE_DIRS}" )
  endif()

  if( MYSQL_LIBRARIES )
    string( REGEX REPLACE "(^| +)-l" ";" MYSQL_LIBRARIES "${MYSQL_LIBRARIES}" )
  endif( )

  set( MYSQL_INCLUDE_DIRS "${MYSQL_INCLUDE_DIRS}" CACHE INTERNAL "" FORCE )
  set( MYSQL_LIBRARIES "${MYSQL_LIBRARIES}" CACHE INTERNAL "" FORCE )

  message( STATUS "    includes ${MYSQL_INCLUDE_DIRS}")
  message( STATUS "    libraries ${MYSQL_LIBRARIES}")
  set( HAVE_MYSQL 1 )

endif( WITH_MYSQL )


##### check for PostgreSQL
if( WITH_POSTGRESQL )

  message( STATUS "Check for PostgreSQL" )
  find_package( PostgreSQL )

  if( PostgreSQL_INCLUDE_DIR AND PostgreSQL_LIBRARY )
    message( STATUS "    includes ${PostgreSQL_INCLUDE_DIR}")
    message( STATUS "    library ${PostgreSQL_LIBRARY}")
    set( HAVE_POSTGRESQL 1 )
  else()
    pkg_search_module( LIBPQ libpq )

    if( NOT LIBPQ_FOUND )
      tde_message_fatal( "PostgreSQL support was requested but Postgresql was not found on your system." )
    endif()

    set( PostgreSQL_INCLUDE_DIR "${LIBPQ_INCLUDE_DIRS}" )
    set( PostgreSQL_LIBRARY "${LIBPQ_LIBRARIES}" )
    set( PostgreSQL_LIBRARY_DIRS "${LIBPQ_LIBRARY_DIRS}" )
    set( HAVE_POSTGRESQL 1 )
  endif()

endif( WITH_POSTGRESQL )


##### check for SQLite3

if( WITH_SQLITE3 )

  pkg_search_module( SQLITE3 sqlite3 )
  if( NOT SQLITE3_FOUND )
    tde_message_fatal( "SQLite3 was requested but not found on your system" )
  endif( )

  message( STATUS "sqlite3 linking: ${SQLITE3_LIBRARIES}" )
  set( HAVE_SQLITE3 1 )

endif( WITH_SQLITE3 )
