/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef BIBTEXFILEEXPORTERRIS_H
#define BIBTEXFILEEXPORTERRIS_H

#include "fileexporter.h"

namespace BibTeX
{

    class FileExporterRIS : public FileExporter
    {
    public:
        FileExporterRIS();

        ~FileExporterRIS();

        bool save( TQIODevice* iodevice, const Element* element, TQStringList* errorLog = NULL );
        bool save( TQIODevice* iodevice, const File* bibtexfile, TQStringList* errorLog = NULL );

    public slots:
        void cancel();

    private:
        bool m_cancelFlag;

        bool writeEntry( TQTextStream &stream, const Entry* entry );
        bool writeKeyValue( TQTextStream &stream, const TQString& key, const TQString&value );
    };

}

#endif
