/* ============================================================
 * File  : slideshowgl.h
 * Author: Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Date  : 2004-01-19
 * Description : 
 * 
 * Copyright 2004 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright 2007 by Valerio Fuoglio <valerio.fuoglio@gmail.com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

#ifndef SLIDESHOWGL_H
#define SLIDESHOWGL_H

// KDE includes
#include <tdeconfig.h>

// QT includes 
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqpair.h>
#include <tqstring.h>
#include <tqmap.h>
#include <tqgl.h>

// Local includes
#include "slideshowloader.h"

class TQTimer;

namespace KIPISlideShowPlugin
{
  class SlideShowGL;
  class ToolBar;
  
  class SlideShowGL : public TQGLWidget
  {
        TQ_OBJECT
  
        
    public:
    
        SlideShowGL(const TQValueList<TQPair<TQString, int> >& fileList,
                    const TQStringList& commentsList, bool ImagesHasComments);
        ~SlideShowGL();
    
        void registerEffects();
    
        static TQStringList effectNames();
        static TQMap<TQString,TQString> effectNamesI18N();
        
    protected:
    
        void initializeGL();
        void paintGL();
        void resizeGL(int w, int h);
        
        void mousePressEvent(TQMouseEvent *event);
        void mouseMoveEvent(TQMouseEvent *);
        void wheelEvent(TQWheelEvent *e);
        void keyPressEvent(TQKeyEvent *event);
            
    private:
    
        // config ------------------
    
        TDEConfig*    m_config;
        
        int         m_delay;
        TQString     m_effectName;
        bool        m_loop;
        bool        m_printName;
        bool        m_printProgress;
        bool        m_printComments;
        
        bool        m_imagesHasComments;
        
        TQFont*      m_commentsFont;
        uint        m_commentsFontColor;
        uint        m_commentsBgColor;
        int         m_commentsLinesLength;
        
        bool        m_enableMouseWheel;
    
        uint         m_cacheSize;
        // -------------------------
        
        typedef void (SlideShowGL::*EffectMethod)();
        TQMap<TQString, EffectMethod> m_effects;
    
        TQValueList<TQPair<TQString, int> >  m_fileList;
        TQStringList  m_commentsList;
        TQTimer*      m_timer;
        int          m_fileIndex;
    
        SlideShowLoader*   m_imageLoader;
        GLuint             m_texture[2];
        bool               m_tex1First;
        int                m_curr;
        
        int          m_width;
        int          m_height;
    
        EffectMethod m_effect;
        bool         m_effectRunning;
        int          m_timeout;
        bool         m_random;
        bool         m_endOfShow;
    
        int          m_i;
        int          m_dir;
        float        m_points[40][40][3];
    
        ToolBar*     m_toolBar;
        TQTimer*      m_mouseMoveTimer;
    
        int          m_deskX;
        int          m_deskY;
        int          m_deskWidth;
        int          m_deskHeight;
        
    private:
    
        void          paintTexture();
        void          advanceFrame();
        void          previousFrame();
        void          loadImage();
        void          montage(TQImage& top, TQImage& bot);
        EffectMethod  getRandomEffect();
        void          showEndOfShow();
        void          printFilename(TQImage& layer);
        void          printProgress(TQImage& layer);
        void          printComments(TQImage& layer);
        
        void          readSettings();
        
        void          effectNone();
        void          effectBlend();
        void          effectFade();
        void          effectRotate();
        void          effectBend();
        void          effectInOut();
        void          effectSlide();
        void          effectFlutter();
        void          effectCube();
        
        
    private slots:
    
        void slotTimeOut();
        void slotMouseMoveTimeOut();
    
        void slotPause();
        void slotPlay();
        void slotPrev();
        void slotNext();
        void slotClose();
  };

}  // NameSpace KIPISlideShowPlugin

#endif /* SLIDESHOWGL_H */
