/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_SEGMENTRESIZER_H_
#define _RG_SEGMENTRESIZER_H_

#include "SegmentTool.h"
#include <tqstring.h>


class TQPoint;
class TQMouseEvent;
class CompositionItem;


namespace Rosegarden
{

class RosegardenGUIDoc;
class CompositionView;


/**
 * Segment Resizer tool. Allows resizing only at the end of the segment part
 */
class SegmentResizer : public SegmentTool
{
    TQ_OBJECT
  

    friend class SegmentToolBox;
    friend class SegmentSelector;

public:

    virtual void ready();
    virtual void stow();

    virtual void handleMouseButtonPress(TQMouseEvent*);
    virtual void handleMouseButtonRelease(TQMouseEvent*);
    virtual int  handleMouseMove(TQMouseEvent*);

    static bool cursorIsCloseEnoughToEdge(const CompositionItem&, const TQPoint&, int, bool &);

    void setEdgeThreshold(int e) { m_edgeThreshold = e; }
    int getEdgeThreshold() { return m_edgeThreshold; }

    static const TQString ToolName;

protected slots:
    void slotCanvasScrolled(int newX, int newY);

protected:
    SegmentResizer(CompositionView*, RosegardenGUIDoc*, int edgeThreshold = 10);
    void setBasicContextHelp(bool ctrlPressed = false);

    //--------------- Data members ---------------------------------

    int m_edgeThreshold;
    bool m_resizeStart;
};


}

#endif
