/***************************************************************************
    smb4ksynchronizationinfo  -  This is a container that holds
    information about progress of the synchronization
                             -------------------
    begin                : So Mai 20 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSYNCHRONIZATIONINFO_H
#define SMB4KSYNCHRONIZATIONINFO_H

// TQt includes
#include <tqstring.h>

class Smb4KSynchronizationInfo
{
  public:
    /**
     * The constructor. It takes no arguments and you should use the
     * setXYZ() functions to set the necessary values.
     */
    Smb4KSynchronizationInfo();

    /**
     * The destructor.
     */
    ~Smb4KSynchronizationInfo();

    /**
     * Set the text that's provided in rsync's output. This may either be a
     * file name or some information about the progress
     *
     * @param text        The text
     */
    void setText( const TQString &text );

    /**
     * Return the name of the file that is currently processed. This may
     * be empty if no information about the file name is available.
     *
     * @returns the name of the file that is currently processed or an empty
     * string
     */
    const TQString &text () const { return m_text; }

    /**
     * Set the progress of the file that's currently processed.
     *
     * @param percent     The progress in percent
     */
    void setIndividualProgress( int percent );

    /**
     * Return the progress of the current file transfer. If no
     * information is available, -1 is returned.
     *
     * @returns the progress of the current file transfer or -1.
     */
    const int individualProgress() const { return m_individual_progress; }

    /**
     * Set the total progress of synchronization process.
     *
     * @param percent     The progress in percent
     */
    void setTotalProgress( int percent );

    /**
     * Return the total progress of synchronization process. If no
     * information is available, -1 is returned.
     *
     * @returns the total progress of the synchronization or -1.
     */
    const int totalProgress() const { return m_total_progress; }

    /**
     * Set the total number of files that have been considered for the
     * synchronization.
     *
     * @param total       The total number of files
     */
    void setTotalFileNumber( int total );

    /**
     * Return the total number of files that were considered for synchronization.
     * If no information is available, -1 is returned.
     *
     * @returns the total number of files or -1.
     */
    const int totalFileNumber() const { return m_total_files; }

    /**
     * Set the number of files that have already been processed during the
     * synchronization.
     *
     * @param processed   The number of files that have been processed
     */
    void setProcessedFileNumber( int processed );

    /**
     * Return the number of files that have already been processed during the
     * synchronization. If no information is available, -1 is returned.
     *
     * @returns the number of processed files or -1.
     */
    const int processedFileNumber() const { return m_processed_files; }

    /**
     * Set the transfer rate. This should be a string that already contains
     * all information, i.e. the string should look like this: 100 kB/s.
     *
     * @param rate        The rate string (e.g. 100 kB/s)
     */
    void setTransferRate( const TQString &rate );

    /**
     * Return the transfer rate. This is a string that already contains all
     * information, so that you can just put it into your widget without any
     * modification. It may also be empty if no information about the rate is
     * available.
     *
     * @returns The rate or an empty string.
     */
    const TQString &transferRate() const { return m_rate; }

  private:
    /**
     * The text
     */
    TQString m_text;

    /**
     * The individual progress
     */
    int m_individual_progress;

    /**
     * The total progress
     */
    int m_total_progress;

    /**
     * The total file number
     */
    int m_total_files;

    /**
     * The number of processed files
     */
    int m_processed_files;

    /**
     * The rate string
     */
    TQString m_rate;
};

#endif
