# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2005 Robert Millan
# Copyright © 2009-2010, 2014, 2016 Jonas Smedegaard <dr@jones.dk>
# Copyright © 2013 IOhannes m zmölnig <zmoelnig@iem.at>
# Description: A class to automatically update GNU autotools files
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_class_autotools_files
_cdbs_class_autotools_files = 1

include $(_cdbs_class_path)/tde-autotools-vars.mk$(_cdbs_makefile_suffix)

# Compatibility blurb, will be eventualy removed
ifneq (,$(DEB_AUTO_UPDATE_AUTOMAKE))
ifeq (,$(DEB_AUTO_UPDATE_ACLOCAL))
$(call cdbs_warn,DEB_AUTO_UPDATE_AUTOMAKE will eventually stop implying \
	DEB_AUTO_UPDATE_ACLOCAL.  If you meant aclocal.m4 to be \
	regenerated, please use DEB_AUTO_UPDATE_ACLOCAL.)
DEB_AUTO_UPDATE_ACLOCAL ?= $(DEB_AUTO_UPDATE_AUTOMAKE)
endif
endif

# Some update rules are useless on their own
ifeq (pre,$(DEB_AUTO_UPDATE_LIBTOOL))
ifeq (,$(DEB_AUTO_UPDATE_ACLOCAL))
$(call cdbs_warn,DEB_AUTO_UPDATE_LIBTOOL requires DEB_AUTO_UPDATE_ACLOCAL.)
endif
endif
ifneq (,$(DEB_AUTO_UPDATE_ACLOCAL))
ifeq (,$(DEB_AUTO_UPDATE_AUTOCONF))
$(call cdbs_warn,DEB_AUTO_UPDATE_ACLOCAL requires DEB_AUTO_UPDATE_AUTOCONF.)
endif
endif

DEB_ACLOCAL_ARGS ?= $(if $(wildcard $(DEB_SRCDIR)/m4),\
	-I m4)

# resolve make rule from autotools command version hints
# usage: $(call _cdbs_autotools_invoke,$(VERSION),$(VERSIONEDBINARY),$(BINARY),$(LEGACY))
#  * when VERSION contains comma: return "$(BINARY)"
#  * else, when LEGACY exist: return $$(which "$(VERSIONEDBINARY)$(VERSION)" || which "$(BINARY)")
#  * else: return "$(VERSIONEDBINARY)$(VERSION)"
# see also autotools-vars.mk
_cdbs_autotools_invoke = $(if $(findstring $(comma),$1),\
	$3,\
	$(if $4,\
		$$(which "$2$1" || which "$3"),\
		$2$1))

common-configure-arch common-configure-indep:: debian/stamp-autotools-files
debian/stamp-autotools-files:
	$(if $(filter pre,$(DEB_AUTO_UPDATE_LIBTOOL)),\
		cd $(DEB_SRCDIR) && \
		libtoolize -c -f)
	$(if $(DEB_AUTO_UPDATE_AUTOPOINT),\
		cd $(DEB_SRCDIR) && \
		$(call _cdbs_autotools_invoke,$(DEB_AUTO_UPDATE_AUTOPOINT),autopoint,autopoint) \
			$(DEB_AUTOPOINT_ARGS))
	$(if $(DEB_AUTO_UPDATE_ACLOCAL),\
		cd $(DEB_SRCDIR) && \
		$(call _cdbs_autotools_invoke,$(DEB_AUTO_UPDATE_ACLOCAL),aclocal-,aclocal) \
			$(DEB_ACLOCAL_ARGS))
	$(if $(DEB_AUTO_UPDATE_AUTOCONF),\
		$(if $(wildcard $(DEB_SRCDIR)/configure.ac $(DEB_SRCDIR)/configure.in),\
			cd $(DEB_SRCDIR) && \
			$(call _cdbs_autotools_invoke,$(DEB_AUTO_UPDATE_AUTOCONF),autoconf,autoconf,legacy) \
				$(DEB_AUTOCONF_ARGS)))
	$(if $(DEB_AUTO_UPDATE_AUTOHEADER),\
		$(if $(wildcard $(DEB_SRCDIR)/configure.ac $(DEB_SRCDIR)/configure.in),\
			cd $(DEB_SRCDIR) && \
			$(call _cdbs_autotools_invoke,$(DEB_AUTO_UPDATE_AUTOHEADER),autoheader,autoheader,legacy) \
				$(DEB_AUTOHEADER_ARGS)))
	$(if $(DEB_AUTO_UPDATE_AUTOMAKE),\
		$(if $(wildcard $(DEB_SRCDIR)/Makefile.am),\
			cd $(DEB_SRCDIR) && \
			$(call _cdbs_autotools_invoke,$(DEB_AUTO_UPDATE_AUTOMAKE),automake-,automake) \
				$(DEB_AUTOMAKE_ARGS)))
	touch debian/stamp-autotools-files

clean::
	rm -f debian/stamp-autotools-files

endif
