/***************************************************************************

                       edit common properties

    -----------------------------------------------------------------------

    begin          : Mon Jun 28 21:02:16 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "CommonEntryPage.h"
#include "EntryDlg.h"

#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>
#include <tqgroupbox.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <kdialogbase.h>

#include <QueryManager.h>
#include <langset.h>

#include "DocPropDlg.h"
#include "blockall.h"
#include "PhoneticEntryPage.h"


CommonEntryPage::CommonEntryPage
(
  EntryDlg     *_dlgbook,
  kvoctrainDoc *_doc,
  bool          multi_sel,
  TQString       expr,
  int           less,
  TQComboBox    *lessbox,
  TQString       lang,
  TQString       act_type,
  TQString       pron,
  TQString       act_usage,
  TQString       label,
  QueryManager &_querymanager,
  bool          active,
  const TQFont&  _ipafont,
  TQWidget      *parent,
  const char   *name
)
  :
  CommonEntryPageForm( parent, name ),
  pronunce(pron),
  expression(expr),
  usageCollection (act_usage),
  lesson(less),
  type (act_type),
  dlgbook(_dlgbook),
  doc(_doc),
  querymanager(_querymanager),
  entry_active(active),
  ipafont(_ipafont)
{

  connect( b_usageDlg, TQ_SIGNAL(clicked()), TQ_SLOT(invokeUsageDlg()) );
  connect( b_LessDlg, TQ_SIGNAL(clicked()), TQ_SLOT(invokeLessDlg()) );
  connect( b_pronDlg, TQ_SIGNAL(clicked()), TQ_SLOT(invokePronDlg()) );
  connect( b_TypeDlg, TQ_SIGNAL(clicked()), TQ_SLOT(invokeTypeDlg()) );
  connect( usage_box, TQ_SIGNAL(selectionChanged()), TQ_SLOT(slotUsageChanged()) );
  connect( lesson_box, TQ_SIGNAL(activated(int)), TQ_SLOT(slotLessonSelected(int)) );
  connect( subtype_box, TQ_SIGNAL(activated(int)), TQ_SLOT(slotSubTypeSelected(int)) );
  connect( type_box, TQ_SIGNAL(activated(int)), TQ_SLOT(slotTypeSelected(int)) );
  connect( c_active, TQ_SIGNAL(toggled(bool)), TQ_SLOT(slotActiveChanged(bool)) );

  connect( pronunce_line, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(slotPronunceSelected(const TQString&)) );
  connect( expr_line, TQ_SIGNAL(textChanged(const TQString&)), TQ_SLOT(slotExprSelected(const TQString&)) );

  usage_label->setTitle(i18n("Usage (area) of an Expression", "&Usage Labels"));
  pronunce_line->setFont(ipafont);

  lesson_box->setValidator (new BlockAllValidator() );
  type_box->setValidator (new BlockAllValidator() );
  subtype_box->setValidator (new BlockAllValidator() );

  TQPixmap list_pm = SmallIcon("view_text");
  b_LessDlg->setPixmap(list_pm);
  b_TypeDlg->setPixmap(list_pm);
  b_usageDlg->setPixmap(list_pm);

  TQPixmap pron_pm = SmallIcon("view_icon");
  b_pronDlg->setPixmap(pron_pm);

  setData(multi_sel, expr, less, lessbox, lang, type, pronunce, act_usage, label, querymanager, active);
}


void CommonEntryPage::setData(
  bool          multi_sel,
  TQString       expr,
  int           less,
  TQComboBox    *lessBox,
  TQString       /*lang*/,
  TQString       type,
  TQString       pronunce,
  TQString       usage,
  TQString       /*label*/,
  QueryManager &/*querymanager*/,
  bool          active)
{
  setLessonBox (lessBox, less);
  setUsageBox (usage);

  //expr_label->setText( label );
  expr_line->setText(expr);

  setTypeBox(type);
  pronunce_line->setText(pronunce);
  c_active->setChecked(active);

  int start = -1;
  int i = 0;
  while (start < 0 && i < (int) all_types.size()) {
    if (all_types [i].shortStr() == QueryManager::getMainType(type))
      start = i;
    i++;
  }
  int offset = -1;
  while (offset < 0 && i < (int) all_types.size()) {
    if (all_types [i].shortStr() == type)
      offset = i - start;
    i++;
  }
  if (offset >= 0) {
    slotSubTypeSelected(offset);
    subtype_box->setCurrentItem(offset);
  }

  if (multi_sel) {
    expr_line->setEnabled (false);
    pronunce_line->setEnabled (false);
    expr_line->setText ("");
    pronunce_line->setText ("");
    lesson_box->clearEdit();
    type_box->clearEdit();
    subtype_box->clearEdit();
  }

  lesson_dirty = false;
  type_dirty = false;
  usage_dirty = false;
  active_dirty = false;

  setModified(false);
}


void CommonEntryPage::setTypeBox(const TQString &act_type)
{
  all_types = QueryManager::getRelation(false);
  all_maintypes = QueryManager::getRelation(true);

  TQString s = QueryManager::getMainType(act_type)+TQM_TYPE_DIV;
  int curr_type = 0;
  type_box->clear();
  type_box->insertItem (i18n("<none>"));
  for (int i = 0; i < (int) all_maintypes.size(); i++) {
    type_box->insertItem (all_maintypes[i].longStr());
    if (s == all_maintypes[i].shortStr()+TQM_TYPE_DIV)
      curr_type = i+1;
  }
  type_box->setCurrentItem(curr_type);
  slotTypeSelected(curr_type);
}


void CommonEntryPage::setLessonBox(TQComboBox *lessbox, int lesson)
{
  lesson_box->clear();
  for (int i = 0; i < lessbox->count(); i++)
    lesson_box->insertItem (lessbox->text(i));
  if (lesson >= lesson_box->count() )
    lesson = 0;
  lesson_box->setCurrentItem(lesson);
}


void CommonEntryPage::setUsageBox(const TQString & act_usage)
{
  usages = UsageManager::getRelation();
  usage_box->clear();
  for (int i = 0; i < (int) usages.size(); i++) {
    usage_box->insertItem (usages[i].longStr());
    if (UsageManager::contains(TQString(usages[i].identStr()), act_usage)) {
      usage_box->setSelected (i, true);
    }
  }
  slotUsageChanged();
}


void CommonEntryPage::slotUsageChanged()
{
  setModified(true);
  usageCollection = "";
  usage_dirty = true;
  TQString s;
  for (int i = 0; i < (int) usage_box->count(); i++) {
    if (usage_box->isSelected(i)) {

      if (!usageCollection.isEmpty() )
        usageCollection += UL_USAGE_DIV;
      usageCollection += usages[i].identStr();

      if (!s.isEmpty() )
        s += ", ";
      s += usages[i].shortStr();
    }
  }
  usage_line->setText (s);
}


void CommonEntryPage::slotLessonSelected (int l)
{
  setModified(true);
  lesson = l;
  lesson_dirty = true;
}


void CommonEntryPage::slotActiveChanged(bool state)
{
  setModified(true);
  entry_active = state;
  active_dirty = true;
}


void CommonEntryPage::slotExprSelected (const TQString& s)
{
  setModified(true);
  expression = s;
}


void CommonEntryPage::slotPronunceSelected (const TQString& s)
{
  setModified(true);
  pronunce = s;
}


void CommonEntryPage::slotSubTypeSelected(int i)
{
  setModified(true);
  if (i < (int) current_subtypes.size()) {
    type = current_subtypes[i];
    emit typeSelected(type);
    type_dirty = true;
  }
}


void CommonEntryPage::slotTypeSelected(int idx)
{
  setModified(true);
  subtype_box->clear();
  current_subtypes.clear();
  bool first = true;

  if (idx == 0) { // 0 == none !
    type = "";
    emit typeSelected(type);
  }
  else {
    type = all_maintypes[idx-1].shortStr();
    emit typeSelected(type);
    TQString main_patt = all_maintypes[idx-1].shortStr()+TQM_TYPE_DIV;
    int sub_idx;
    if ( idx-1 < (int) all_types.size() ){
      for (sub_idx = 0; sub_idx < (int) all_types.size(); sub_idx++) {
        if (all_types[sub_idx].shortStr().left(main_patt.length()) == main_patt) {
          if (first) {
            subtype_box->insertItem (i18n("<none>"));
            current_subtypes.push_back(all_maintypes[idx-1].shortStr());
            first = false;
          }
          TQString s = all_types[sub_idx].longStr();
          subtype_box->insertItem (s.stripWhiteSpace());
          current_subtypes.push_back(all_types[sub_idx].shortStr());
        }
      }
    }
  }
  type_dirty = true;

  subtype_box->setEnabled(!first);
  subtype_label->setEnabled(!first);
}


void CommonEntryPage::phoneticSelected(wchar_t wc)
{
  setModified(true);
  pronunce += TQChar(wc);
  pronunce_line->setText(pronunce);
}


void CommonEntryPage::invokePronDlg()
{
  //if (phoneticDlg == 0) {
    PhoneticEntryPage * phoneticDlg = new PhoneticEntryPage (ipafont, this);
    connect (phoneticDlg, TQ_SIGNAL(charSelected(wchar_t)), TQ_SLOT(phoneticSelected(wchar_t)) );
    phoneticDlg->show();
  //}
  //else
    //phoneticDlg->show();
}


void CommonEntryPage::invokeUsageDlg()
{
  vector<int> usageIndex;
  vector<TQString> new_usageStr;

  int old_usages = (int) doc->getUsageDescr().size();

  KDialogBase usageOpt(KDialogBase::Swallow, i18n("usage (area) of an expression", "Edit User-Defined Usage Labels"),
    KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, dlgbook, "usage", true);

  UsageOptPage *usageOptPage = new UsageOptPage (doc->getUsageDescr(), doc, this, "name");
  usageOpt.setMainWidget(usageOptPage);

  if (usageOpt.exec() == TQDialog::Accepted)
  {
    usageOptPage->getUsageLabels(new_usageStr, usageIndex);
    UsageOptPage::cleanUnused(doc, usageIndex, old_usages);
    UsageManager::setUsageNames (new_usageStr);
    setUsageBox(usageCollection);
    doc->setUsageDescr (new_usageStr);
    doc->setModified();
  }
}


void CommonEntryPage::invokeLessDlg()
{
  vector<int> lessonIndex;
  vector<TQString> new_lessonStr;

  int old_lessons = (int) lesson_box->count();
  KDialogBase lessOpt(KDialogBase::Swallow, i18n("Edit Lesson Names"),
    KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, dlgbook, "lesson", true);

  LessOptPage *lessOptPage = new LessOptPage (lesson_box, doc, this, "name");
  lessOpt.setMainWidget(lessOptPage);

  vector<int> lessoninquery = doc->getLessonsInQuery();
  if (lessOpt.exec() == TQDialog::Accepted)
  {
    lessOptPage->getLesson(lesson_box, lessonIndex);
    LessOptPage::cleanUnused(doc, lesson_box, lessonIndex, old_lessons, lessoninquery);
    for (int i = 1; i < lesson_box->count(); i++)
      new_lessonStr.push_back(lesson_box->text(i));
    doc->setLessonDescr (new_lessonStr);
    doc->setLessonsInQuery(lessoninquery);
    querymanager.setLessonItems(lessoninquery);
    doc->setModified();
  }
}


void CommonEntryPage::invokeTypeDlg()
{
  vector<int> typeIndex;
  vector<TQString> new_typeStr;

  int old_types = (int) doc->getTypeDescr().size();
  KDialogBase typeOpt(KDialogBase::Swallow, i18n("Edit User Defined Types"),
    KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, dlgbook, "types", true);

  TypeOptPage *typeOptPage = new TypeOptPage (doc->getTypeDescr(), doc, this, "name");
  typeOpt.setMainWidget(typeOptPage);

  if (typeOpt.exec() == TQDialog::Accepted)
  {
    typeOptPage->getTypeNames(new_typeStr, typeIndex);
    TypeOptPage::cleanUnused(doc, typeIndex, old_types);
    QueryManager::setTypeNames (new_typeStr);
    setTypeBox(type);
    doc->setTypeDescr (new_typeStr);
    doc->setModified();
  }
}


bool CommonEntryPage::isModified()
{
  return modified;
}


void CommonEntryPage::setEnabled(int enable)
{
  bool ena = enable == EntryDlg::EnableAll;

  usage_box->setEnabled(ena);
  subtype_box->setEnabled(ena);
  type_box->setEnabled(ena);
  pronunce_line->setEnabled(ena);
  expr_line->setEnabled(ena);

  lesson_box->setEnabled(ena || enable == EntryDlg::EnableOnlyCommon);
  c_active->setEnabled(ena || enable == EntryDlg::EnableOnlyCommon);
}


void CommonEntryPage::setModified(bool mod)
{
  modified = mod;
  if (mod)
    emit sigModified();
}

#include "CommonEntryPage.moc"
