/***************************************************************************
 *
 * tdenetman-vpnauthenticationdialog.cpp - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#include <stdlib.h>
#include <kpushbutton.h>
#include <tqbuttongroup.h>
#include <tqcombobox.h>
#include <tqmessagebox.h>
#include <tqwidgetstack.h>
#include <klineedit.h>
#include <tqlabel.h>
#include <tdelocale.h>
#include <kdebug.h>
#include <tqobjectlist.h>
#include <tqcheckbox.h>
#include <tqfocusdata.h>
#include <kiconloader.h>
#include <tqmap.h>

#include "tdenetman-vpnservice.h"
#include "tdenetman-vpnmanager.h"
#include "tdenetman-vpnauthenticationdialog.h"

/*
 * class VPNAuthenticationDialog
 *
 */
VPNAuthenticationDialog::VPNAuthenticationDialog(TDEVPNConnection* conn, TQWidget* parent, const char* name, bool modal, WFlags fl)
	: AuthenticationDialog(parent, name, modal, fl)
	, _conn(conn)
{
	this->setIcon(SmallIcon("encrypted", TQIconSet::Automatic));
	this->setCaption(i18n("VPN Authentication for %1").arg(conn->friendlyName));
	labelPixmap->setPixmap(TDEGlobal::instance()->iconLoader()->loadIcon("encrypted", TDEIcon::Small, 32));

	// nice icons
	pushOK->setIconSet(SmallIcon("button_ok", TQIconSet::Automatic));
	pushCancel->setIconSet(SmallIcon("button_cancel", TQIconSet::Automatic));

	// we need the last widget in the focus queue
	TQFocusData* foc = focusData();
	TQWidget* lastFocusWidget = foc->last();

	TDEVPNConnection* vpn = conn;
	VPNService* vpnservice = VPNManager::getVPNService(vpn->vpnPluginID);
	
	// get the appropriate plugin and create the authentication widget
	VPNPlugin* vpnPlugin = vpnservice->getVPNPlugin();
	if (vpnPlugin)
	{
		_vpnAuthWidget = vpnPlugin->CreateAuthenticationWidget(widgetStack);
		if (_vpnAuthWidget)
		{
			_vpnAuthWidget->setVPNData(conn->ipConfig.routeConfigurations, conn->pluginData, conn->pluginSecrets);
			widgetStack->raiseWidget(_vpnAuthWidget);
		}
	}
	
	/*
	 the widgets inside the authenticationwidget are now in the focus queue
	 ==> we can now search the first widget inside the authenticationwidget 
	     which has to get the focus
	*/
	TQWidget* widget = foc->home();
	for (int i = 0; i < foc->count(); ++i)
	{
		if (widget == lastFocusWidget)
		{
			// the next one is the first widget inside the authwidget
			widget = foc->next();
			break;
		}
		widget = foc->next();
	}
	if (widget)
		widget->setFocus();

	// resize
	this->resize(minimumSizeHint());
}

VPNAuthenticationDialog::~VPNAuthenticationDialog()
{
	
}

bool VPNAuthenticationDialog::close(bool alsoDelete)
{
	return AuthenticationDialog::close(alsoDelete);
}

void VPNAuthenticationDialog::ok()
{
	TQDialog::done(0);
}

void VPNAuthenticationDialog::setPasswords(TDENetworkSettingsMap secrets) {
	if (secrets.count() > 0) {
		chkStorePasswordsPermanent->setChecked(true);
		_vpnAuthWidget->setPasswords(secrets);
	}
}

void VPNAuthenticationDialog::cancel()
{
/*
	TQStringList x;
	emit done (true, x, false, false);
	TQDialog::done(1);*/

	printf("Attempting to deactivate VPN connection...\n");

	// Quit the dialog
	TQDialog::done(1);
}

#include "tdenetman-vpnauthenticationdialog.moc"
