/***************************************************************************
                          widgetplugins.cpp  -  description
                             -------------------
    begin                : Mi Aug 27 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/widgetplugins.h"
#include "include/pluginmanager.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <twin.h>
#include <tqwidget.h>
#include <tdeconfig.h>
#include <tdelocale.h>

WidgetPluginBase::WidgetPluginBase(const TQString &name, const TQString &description)
  : PluginBase(name, description),
    m_geoCacheValid(false),
    m_geoRestoreFlag(false),
    m_restoreShow(false)
{
}

/*
TQWidget *WidgetPluginBase::getWidget()
{
    return dynamic_cast<TQWidget*>(this);
}


const TQWidget *WidgetPluginBase::getWidget() const
{
    return dynamic_cast<const TQWidget*>(this);
}
*/

void WidgetPluginBase::notifyManager(bool shown)
{
    if (m_manager)
        m_manager->noticeWidgetPluginShown(this, shown);
}


bool WidgetPluginBase::isReallyVisible(const TQWidget *_w) const
{
    const TQWidget *w = _w ? _w : getWidget();
    if (!w) return false;
    KWin::WindowInfo i = KWin::WindowInfo(w->winId(), 0, 0);
    return (i.mappingState() == NET::Visible)
            && w->isVisible()
            && (i.onAllDesktops() || i.isOnCurrentDesktop());
}


bool WidgetPluginBase::isAnywhereVisible(const TQWidget *_w) const
{
    const TQWidget *w = _w ? _w : getWidget();
    if (!w) return false;
    return w->isVisible();
}


void WidgetPluginBase::pShow(bool on)
{
    TQWidget *w = getWidget();
    if (!w) return;
    if (on && !isReallyVisible(w))
        w->show();
    else if (!on && !w->isHidden())
        w->hide();
}


void WidgetPluginBase::pToggleShown()
{
    TQWidget *w = getWidget();
    if (!w) return;
    if (!isReallyVisible(w))
        w->show();
    else
        w->hide();
}


void WidgetPluginBase::pShowOnOrgDesktop()
{
    KWin::setMainWindow(getWidget(), 0);

    logDebug(TQString("%1::pShowOnOrgDesktop: all: %2, desktop: %3, visible:%4, anywherevisible:%5, cachevalid: %6").arg(name()).arg(m_saveSticky).arg(m_saveDesktop).arg(isReallyVisible()).arg(isAnywhereVisible()).arg(m_geoCacheValid));
    if (m_geoCacheValid && (!isReallyVisible() || m_geoRestoreFlag) ) {
        TQWidget *w = getWidget();
        if (!w) return;
        WId  id = w->winId();

        KWin::setOnAllDesktops(id, m_saveSticky);
        if (!m_saveSticky) {
            KWin::setOnDesktop(id, m_saveDesktop);
        }

        w->resize(m_saveGeometry.size());
        w->move(m_saveGeometry.topLeft());

        if (m_saveMinimized) {
            w->showMinimized();
            KWin::iconifyWindow(id);
        } else if (m_saveMaximized) {
            w->showMaximized();
        } else {
            w->showNormal();
            KWin::deIconifyWindow(id);
        }

    }
}

void WidgetPluginBase::pShow()
{
    KWin::setMainWindow(getWidget(), 0);

    logDebug(TQString("%1::pShow: all: %2, desktop: %3, visible:%4, anywherevisible:%5, cachevalid: %6").arg(name()).arg(m_saveSticky).arg(m_saveDesktop).arg(isReallyVisible()).arg(isAnywhereVisible()).arg(m_geoCacheValid));
    if (m_geoCacheValid && (!isReallyVisible() || m_geoRestoreFlag) ) {
        TQWidget *w = getWidget();
        if (!w) return;
        WId  id = w->winId();

        KWin::setOnAllDesktops(id, m_saveSticky);
        if (!m_saveSticky)
            KWin::setOnDesktop(id, KWin::currentDesktop());

        w->resize(m_saveGeometry.size());
        w->move(m_saveGeometry.topLeft());
        KWin::deIconifyWindow(id);
    }
}


void WidgetPluginBase::pHide()
{
    logDebug(TQString("%1::pHide1: all: %2, desktop: %3, visible:%4, anywherevisible:%5, cachevalid: %6").arg(name()).arg(m_saveSticky).arg(m_saveDesktop).arg(isReallyVisible()).arg(isAnywhereVisible()).arg(m_geoCacheValid));
    getKWinState();
    logDebug(TQString("%1::pHide2: all: %2, desktop: %3, visible:%4, anywherevisible:%5, cachevalid: %6").arg(name()).arg(m_saveSticky).arg(m_saveDesktop).arg(isReallyVisible()).arg(isAnywhereVisible()).arg(m_geoCacheValid));
}


void WidgetPluginBase::pShowEvent(TQShowEvent *)
{
    notifyManager (true);
}


void WidgetPluginBase::pHideEvent(TQHideEvent *)
{
    notifyManager (false);
}


void WidgetPluginBase::getKWinState(const TQWidget *_w) const
{
    if (m_geoRestoreFlag) return;

    const TQWidget *w = _w ? _w : getWidget();
    if (!w) return;
    if (w->isVisible()) {
        KWin::WindowInfo i = KWin::WindowInfo(w->winId(), 0, 0);
        m_saveMinimized    = i.isMinimized();
        m_saveMaximized    = w->isMaximized();
        m_saveSticky       = i.onAllDesktops();
        m_saveDesktop      = i.desktop();
        m_saveGeometry     = TQRect(w->pos(), w->size());
        m_geoCacheValid    = true;
    }
}


void   WidgetPluginBase::saveState (TDEConfig *config) const
{
    const TQWidget *w = getWidget();
    getKWinState(w);

    config->writeEntry("hidden",   w ? w->isHidden() : false);
    config->writeEntry("minimized",  m_saveMinimized);
    config->writeEntry("maximized",  m_saveMaximized);
    config->writeEntry("sticky",     m_saveSticky);
    config->writeEntry("desktop",    m_saveDesktop);
    config->writeEntry("geometry",   m_saveGeometry);
    config->writeEntry("geoCacheValid", m_geoCacheValid);
}


void   WidgetPluginBase::restoreState (TDEConfig *config, bool showByDefault)
{
    m_geoCacheValid = config->readBoolEntry("geoCacheValid", false);
    m_saveDesktop   = config->readNumEntry ("desktop",        1);
    m_saveSticky    = config->readBoolEntry("sticky",     false);
    m_saveMaximized = config->readBoolEntry("maximized",  false);
    m_saveMinimized = config->readBoolEntry("minimized",  false);
    m_saveGeometry  = config->readRectEntry("geometry");

    m_restoreShow  = !config->readBoolEntry("hidden", !showByDefault);
}


void   WidgetPluginBase::restoreState (TDEConfig *config)
{
    restoreState(config, true);
}


void   WidgetPluginBase::startPlugin()
{
    PluginBase::startPlugin();

    TQWidget *w = getWidget();
    if (w) {
        m_geoRestoreFlag = true;
        if (!m_restoreShow) w->hide();
        else                w->show();
        m_geoRestoreFlag = false;
    }
}

