/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pspinbox.h"

#include <limits.h>

#include <tqspinbox.h>
#include <tqlayout.h>

namespace PropertyLib{

PSpinBox::PSpinBox(MultiProperty *property, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQSpinBox(INT_MIN, INT_MAX, 1, this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    connect(m_edit, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(updateProperty(int)));
}

PSpinBox::PSpinBox(MultiProperty *property, int minValue, int maxValue, int step, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQSpinBox(minValue, maxValue, step, this);
    l->addWidget(m_edit);
    
    connect(m_edit, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(updateProperty(int)));
}

TQVariant PSpinBox::value() const
{
    return TQVariant(m_edit->cleanText().toInt());
}

void PSpinBox::setValue(const TQVariant &value, bool emitChange)
{
    disconnect(m_edit, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(updateProperty(int)));
    m_edit->setValue(value.toInt());
    connect(m_edit, TQ_SIGNAL(valueChanged(int)), this, TQ_SLOT(updateProperty(int)));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PSpinBox::updateProperty(int val)
{
    emit propertyChanged(m_property, TQVariant(val));
}

}

#ifndef PURE_QT
#include "pspinbox.moc"
#endif
