#################################################
#
#  (C) 2010 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### find X11

find_package( X11)


if( (BUILD_QUANTA) OR (BUILD_KLINKSTATUS) )

##### check for icu's c++ standard

    pkg_search_module( ICU_UC icu-uc )
    tde_execute_process(
        COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=CXXFLAGS icu-uc
        OUTPUT_VARIABLE ICU_CXXFLAGS
        OUTPUT_STRIP_TRAILING_WHITESPACE
    )


##### check for libxml-2.0

    pkg_search_module( LIBXML libxml-2.0>=2.6 )

    if( NOT LIBXML_FOUND )
        tde_message_fatal( "libxml-2.0 version >= 2.6 is required but was not found on your system" )
    endif( NOT LIBXML_FOUND )


##### check for libxslt

    pkg_search_module( LIBXSLT libxslt )

    if( NOT LIBXSLT_FOUND )
        tde_message_fatal( "libxslt are required, but not found on your system" )
    endif( NOT LIBXSLT_FOUND )


    if( BUILD_QUANTA )
        if( WITH_QUANTA_CVSSERVICE )
            tde_import( cervisia )
            find_file( CVSSERVICE_HEADERS NAMES repository_stub.h cvsservice_stub.h cvsjob_stub.h )
            if( CVSSERVICE_HEADERS )
                set( ENABLE_CVSSERVICE 1 )
                set( CVSSERVICE_LIBRARIES "cvsservice-static;cvsservice-shared" CACHE INTERNAL "tdesdk and embedded cvssercice libs" FORCE )
            else()
                tde_message_fatal( "csv service (cervisia) is required for quanta but not found on your system." )
            endif()
        endif()

        find_program( WGET_EXECUTABLE wget )
        if( NOT WGET_EXECUTABLE )
            message( STATUS "wget (download utility) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( TIDY_EXECUTABLE NAMES tidy tidy5 )
        if( NOT TIDY_EXECUTABLE )
            message( STATUS "tidy (HTML/XML syntax checker) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( TDEFILEREPLACE_EXECUTABLE tdefilereplace )
        if( NOT TDEFILEREPLACE_EXECUTABLE )
            message( STATUS "tdefilereplace (Batch search and replace tool - tdeutils) installation is advised since some quanta's features will make use of It." )
        endif()

        find_program( KOMPARE_EXECUTABLE kompare )
        if( NOT KOMPARE_EXECUTABLE )
            message( STATUS "kompare (diff utility - tdesdk) installation is advised since some quanta's features will make use of It." )
        endif()
    endif( BUILD_QUANTA )

endif( (BUILD_QUANTA) OR (BUILD_KLINKSTATUS) )


##### option other editors

if( WITH_OTHER_EDITORS )
    set( ENABLE_EDITORS 1 )
endif( WITH_OTHER_EDITORS )


##### define TQTDOCDIR

if( BUILD_KOMMANDER )
    if( NOT DEFINED TQTDOCDIR )
        find_path( TQT_DOCDIR ntqsql.html
                   PATHS
                       ${TQTDIR}/doc/html $ENV{TQTDIR}/doc/html
                       /opt/trinity/share/tqt3/doc/html
                       /usr/share/doc/packages/tqt3/html
                       /usr/lib/tqt3/doc
                       /usr/lib/tqt3/doc/html
                       /usr/doc/tqt3/html
                       /usr/doc/tqt3
                       /usr/share/doc/tqt3-doc
                       /usr/share/tqt3/doc/html
                       /usr/X11R6/share/doc/tqt/html
        )
        if( TQT_DOCDIR )
            set( TQTDOCDIR "${TQT_DOCDIR}" )
        endif()
    endif()
endif( BUILD_KOMMANDER )
