/***************************************************************************
                            conditionalbreakpointdialog.cpp
                            --------------------
    begin                : 2005-01-08
    copyright            : (C) 2004 Linus McCabe <linus@mccabe.nu>
 ***************************************************************************/

/****************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/


#include "conditionalbreakpointdialog.h"
#include <tqlistview.h>
#include <tqlineedit.h>
#include <qextfileinfo.h>
#include <tqcolor.h>
#include <kcombobox.h>
#include <kled.h>
#include <kiconloader.h>
#include <tqpushbutton.h>
#include <tqradiobutton.h>

#include "debuggerbreakpoint.h"

ConditionalBreakpointDialog::ConditionalBreakpointDialog(const TQString& expression, const TQString& inFile, const TQString& inClass, const TQString& inFunction)
    : ConditionalBreakpointDialogS(0, "ConditionalBreakpointDialog", false, 0)
{
  comboExpression->setCurrentText(expression);
  lineFile->setText(inFile);
  lineClass->setText(inClass);
  lineFunction->setText(inFunction);

  buttonClearFile->setPixmap(SmallIcon("clear_left"));
  buttonClearClass->setPixmap(SmallIcon("clear_left"));
  buttonClearFunction->setPixmap(SmallIcon("clear_left"));
  
  connect(comboExpression, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(slotExpressionChanged()));

  connect(buttonClearFile, TQ_SIGNAL(pressed()), this, TQ_SLOT(slotClearFile()));
  connect(buttonClearClass, TQ_SIGNAL(pressed()), this, TQ_SLOT(slotClearClass()));
  connect(buttonClearFunction, TQ_SIGNAL(pressed()), this, TQ_SLOT(slotClearFunction()));

  slotExpressionChanged();
}

ConditionalBreakpointDialog::~ConditionalBreakpointDialog()
{
}

void ConditionalBreakpointDialog::slotExpressionChanged()
{

  if(comboExpression->currentText().find( TQRegExp("[^=!]=[^=]"), 0 ) >= 0)
    ledWarning->on();
  else
    ledWarning->off();
    
}

void ConditionalBreakpointDialog::slotClearFile()
{
  lineFile->setText("");
}

void ConditionalBreakpointDialog::slotClearClass()
{
  lineClass->setText("");
}

void ConditionalBreakpointDialog::slotClearFunction()
{
  lineFunction->setText("");
}

/*DebuggerBreakpoint::Types type()*/

DebuggerBreakpoint *ConditionalBreakpointDialog::breakpoint()
{
  if(comboExpression->currentText().isEmpty())
    return NULL;
    
  DebuggerBreakpoint *bp = new DebuggerBreakpoint(
    (radioOnChange->isChecked() ? DebuggerBreakpoint::ConditionalChange : DebuggerBreakpoint::ConditionalTrue),
    comboExpression->currentText(),
    lineFile->text(),
    lineClass->text(),
    lineFunction->text());

  return bp;
}


#include "conditionalbreakpointdialog.moc"

