/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  Partially based on code from kdbusnotification
  Copyright © 2021 Emanoil Kotsev <deloptes@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __PORTAL_SERVICE_H
#define __PORTAL_SERVICE_H

// TQt
#include <tqdbusconnection.h>
#include <tqdbusobject.h>

// DBus
#include "interfaces/desktopNode.h"
#include "interfaces/dbusbaseNode.h"

#define REGISTER_PORTAL(klass) \
    m_interfaces.insert(klass::interface(), new klass(connection));

#define DESTROY_PORTAL(klass) \
    delete m_interfaces[klass::interface()];

/**
 * DesktopNodeService
 *  Service  : org.freedesktop.DBus.Introspectable
 *  Path     : /org/freedesktop/portal/desktop
 *  Children : -
 */
class DesktopNodeService : public org::freedesktop::portal::desktopNode
{
    public:
        DesktopNodeService(TQT_DBusConnection&);
        ~DesktopNodeService();

    protected:
        virtual TQT_DBusObjectBase* createInterface(const TQString&);

    private:
        TQMap<TQString, TQT_DBusObjectBase*> m_interfaces;
        TQT_DBusConnection m_connection;
};

/**
 * PortalNodeService
 *  Service  : -
 *  Path     : /org/freedesktop/portal
 *  Children : Desktop
 */
class PortalNodeService : public DBusBaseNode
{
    public:
        PortalNodeService(TQT_DBusConnection&);
        ~PortalNodeService();

    protected:
        virtual TQT_DBusObjectBase* createInterface(const TQString&);

    private:
        TQMap<TQString, TQT_DBusObjectBase*> m_interfaces;
        TQT_DBusConnection m_connection;
};

/**
 * FreeDesktopNodeService
 *  Service  : -
 *  Path     : /org/freedesktop
 *  Children : portal
 */
class FreeDesktopNodeService : public DBusBaseNode
{
    public:
        FreeDesktopNodeService(TQT_DBusConnection&);
        ~FreeDesktopNodeService();

    protected:
        virtual TQT_DBusObjectBase* createInterface(const TQString&);

    private:
        TQMap<TQString, TQT_DBusObjectBase*> m_interfaces;
        TQT_DBusConnection m_connection;
};

/**
 * OrgNodeService
 *  Service  : -
 *  Path     : /org
 *  Children : freedesktop
 */
class OrgNodeService : public DBusBaseNode
{
    public:
        OrgNodeService(TQT_DBusConnection&);
        ~OrgNodeService();

    protected:
        virtual TQT_DBusObjectBase* createInterface(const TQString&);

    private:
        TQMap<TQString, TQT_DBusObjectBase*> m_interfaces;
        TQT_DBusConnection m_connection;
};

/**
 * RootNodeService
 *  Service  : -
 *  Path     : /
 *  Children : org
 */
class RootNodeService : public DBusBaseNode
{
    public:
        RootNodeService(TQT_DBusConnection&);
        ~RootNodeService();

    protected:
        virtual TQT_DBusObjectBase* createInterface(const TQString&);

    private:
        TQMap<TQString, TQT_DBusObjectBase*> m_interfaces;
        TQT_DBusConnection m_connection;
};

#endif // __DESTKOP_PORTAL_H

// kate: replace-tabs true; tab-width 4; indent-width 4;