/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 *
 * Date        : 2004-01-02
 * Description : collection setup tab.
 * 
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */

// TQt includes.

#include <tqlayout.h>
#include <tqvbuttongroup.h>
#include <tqvgroupbox.h>
#include <tqhgroupbox.h>
#include <tqgroupbox.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqdir.h>
#include <tqwhatsthis.h>

// KDE includes.

#include <tdelistbox.h>
#include <tdelocale.h>
#include <kdialog.h>
#include <tdefiledialog.h>
#include <kurl.h>
#include <tdemessagebox.h>
#include <kiconloader.h>
#include <tdeversion.h>

#if KDE_IS_VERSION(3,2,0)
#include <kinputdialog.h>
#else
#include <klineeditdlg.h>
#endif

// Local includes.

#include "thumbnailsize.h"
#include "albumsettings.h"
#include "setupcollections.h"
#include "setupcollections.moc"

namespace Digikam
{

class SetupCollectionsPriv
{
public:

    SetupCollectionsPriv()
    {
        albumCollectionBox  = 0;
        addCollectionButton = 0;
        delCollectionButton = 0;
    }
   
    TQListBox     *albumCollectionBox;

    TQPushButton  *addCollectionButton;
    TQPushButton  *delCollectionButton;
};

SetupCollections::SetupCollections(TQWidget* parent )
                : TQWidget(parent)
{
    d = new SetupCollectionsPriv;

    TQVBoxLayout *mainLayout            = new TQVBoxLayout(parent);
    TQGridLayout *collectionGroupLayout = new TQGridLayout( this, 2, 5, 0, KDialog::spacingHint() );

    // --------------------------------------------------------
    
    d->albumCollectionBox = new TDEListBox(this);
    TQWhatsThis::add( d->albumCollectionBox, i18n("<p>You can add or remove Album "
                                                 "collection types here to improve how "
                                                 "your Albums are sorted in digiKam."));
    
    d->albumCollectionBox->setVScrollBarMode(TQScrollView::AlwaysOn);
    
    d->addCollectionButton = new TQPushButton( i18n("&Add..."), this);
    d->delCollectionButton = new TQPushButton( i18n("&Delete"), this);

    d->addCollectionButton->setIconSet(SmallIcon("add"));
    d->delCollectionButton->setIconSet(SmallIcon("remove"));
    d->delCollectionButton->setEnabled(false);
    
    TQSpacerItem* spacer = new TQSpacerItem( 20, 20, TQSizePolicy::Minimum, TQSizePolicy::Expanding );

    collectionGroupLayout->setAlignment( TQt::AlignTop );
    collectionGroupLayout->addMultiCellWidget( d->albumCollectionBox, 0, 4, 0, 0 );
    collectionGroupLayout->addWidget( d->addCollectionButton, 0, 1);
    collectionGroupLayout->addWidget( d->delCollectionButton, 1, 1);
    collectionGroupLayout->addItem( spacer, 4, 1 );
    
    // --------------------------------------------------------
    
    connect(d->albumCollectionBox, TQ_SIGNAL(selectionChanged()),
            this, TQ_SLOT(slotCollectionSelectionChanged()));
    
    connect(d->addCollectionButton, TQ_SIGNAL(clicked()),
            this, TQ_SLOT(slotAddCollection()));
    
    connect(d->delCollectionButton, TQ_SIGNAL(clicked()),
            this, TQ_SLOT(slotDelCollection()));
    
    // --------------------------------------------------------
    
    readSettings();
    adjustSize();
    mainLayout->addWidget(this);
}

SetupCollections::~SetupCollections()
{
    delete d;
}

void SetupCollections::applySettings()
{
    AlbumSettings* settings = AlbumSettings::instance();

    if (!settings) return;

    TQStringList collectionList;

    for (TQListBoxItem *item = d->albumCollectionBox->firstItem();
         item; item = item->next())
    {
        collectionList.append(item->text());
    }

    settings->setAlbumCollectionNames(collectionList);

    settings->saveSettings();
}

void SetupCollections::readSettings()
{
    AlbumSettings* settings = AlbumSettings::instance();

    if (!settings) return;

    d->albumCollectionBox->insertStringList(settings->getAlbumCollectionNames());
}

void SetupCollections::slotCollectionSelectionChanged()
{
    if (d->albumCollectionBox->currentItem() != -1)
        d->delCollectionButton->setEnabled(true);
    else
        d->delCollectionButton->setEnabled(false);
}

void SetupCollections::slotAddCollection()
{
    bool ok;

#if KDE_IS_VERSION(3,2,0)
    TQString newCollection =
        KInputDialog::getText(i18n("New Collection Name"),
                              i18n("Enter new collection name:"),
                              TQString(), &ok, this);
#else
    TQString newCollection =
        KLineEditDlg::getText(i18n("New Collection Name"),
                              i18n("Enter new collection name:"),
                              TQString(), &ok, this);
#endif

    if (!ok) return;

    bool found = false;
    for (TQListBoxItem *item = d->albumCollectionBox->firstItem();
         item; item = item->next()) 
    {
        if (newCollection == item->text()) 
        {
            found = true;
            break;
        }
    }

    if (!found)
        d->albumCollectionBox->insertItem(newCollection);
}

void SetupCollections::slotDelCollection()
{
    int index = d->albumCollectionBox->currentItem();
    if (index == -1)
        return;

    TQListBoxItem* item = d->albumCollectionBox->item(index);
    if (!item) return;
    delete item;
}

}  // namespace Digikam
