/* This file is part of the Keep project
   Copyright (C) 2006 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#include "rdblistener.h"

RDBListener::RDBListener()
{
	m_isOk = true;
}


void RDBListener::receivedStdErr(TDEProcess *proc, char *buffer, int buflen)
{
	m_isOk = false;
	m_stdErr.append(buffer);
}

void RDBListener::receivedStdOut(TDEProcess *proc, char *buffer, int buflen)
{
	m_stdOut.append(buffer);
}

TQString RDBListener::errorMessage()
{
	return m_stdErr.join("").simplifyWhiteSpace();
}

TQStringList RDBListener::stdErr()
{
	return m_stdErr;
}

TQStringList RDBListener::stdOut()
{
	return m_stdOut;
}

bool RDBListener::isOk()
{
	return m_isOk;
}

#include "rdblistener.moc"
