/*
 *   panelComponent.cpp
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "panelComponent.h"

#include <tqdir.h>
#include <tqfileinfo.h>

#include <kdebug.h>
#include <kmimetype.h>
#include <tdeprocess.h>
#include <ksavefile.h>
#include <tdesimpleconfig.h>
#include <tdestandarddirs.h>
#include <kurl.h>

#include "kioskrun.h"

PanelComponent::PanelComponent( TQObject *parent)
 : Component(parent)
{
}

PanelComponent::~PanelComponent()
{
}

void
PanelComponent::slotSetupPrepare()
{
}

void
PanelComponent::slotSetupStarted()
{
}

bool
PanelComponent::setupFinished()
{
   bool result;

   // Install .desktop files
   {
      TQString kickerApplications = KioskRun::self()->locateLocal("data", "kicker/");
      TQString kickerSaveApplications = KioskRun::self()->locateSave("data", "kicker/");

      TQDir dir(kickerApplications);
      TQStringList newKickerApplications = dir.entryList(TQDir::All, TQDir::Unsorted);
      newKickerApplications.remove(".");
      newKickerApplications.remove("..");
   
      for(TQStringList::ConstIterator it = newKickerApplications.begin();
          it != newKickerApplications.end(); ++it)
      {
         if ((*it).endsWith(".desktop"))
         {
            kdDebug() << "PanelComponent: New .desktop file = " << (kickerApplications+(*it)) << endl;
            result = KioskRun::self()->install(kickerApplications+(*it), kickerSaveApplications+(*it));
            if (!result) return false;
         }
      }
   }
   return true;
}

#include "panelComponent.moc"
