/*
 *   userManagement.h
 *
 *   Copyright (C) 2004 Waldo Bastian <bastian@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2 as
 *   published by the Free Software Foundation.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _USERMANAGEMENT_H_
#define _USERMANAGEMENT_H_

#include "pageWidget.h"
#include "userManagement_ui.h"

class UserManagementUI;

class UserManagementPage : public UserManagementUI, public PageWidget
{
  TQ_OBJECT
  
public:  
  UserManagementPage(TQWidget* parent, const char* name = 0, WFlags fl = 0);
  ~UserManagementPage();

  virtual void load();
  virtual bool save();

  virtual void setFocus();

  virtual TQString subCaption();

protected:
  void init();

private slots:
  void slotAddGroup();
  void slotDeleteGroup();
  void slotAddUser();
  void slotDeleteUser();

  void slotUpdateButtons();
  void slotShowNotice();

private:
  UserManagementUI *w;
  TQStringList m_allUsers;
  TQStringList m_allGroups;
  TQStringList m_allProfiles;
};

#endif
