/* ============================================================
 * File  : galleryconfig.cpp
 * Author: Colin Guthrie <kde@colin.guthr.ie>
 * Date  : 2006-09-04
 * Copyright 2006 by Colin Guthrie <kde@colin.guthr.ie>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqlistview.h>
#include <tqpushbutton.h>
#include <tqtimer.h>
#include <tqpixmap.h>
#include <tqcursor.h>
#include <tqlineedit.h>
#include <tqprogressdialog.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>

// Include files for KDE

#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <krun.h>
#include <kdebug.h>
#include <tdeconfig.h>

// KIPI include files

#include <libkipi/version.h>
#include <libkipi/interface.h>
#include <libkipi/imagedialog.h>

// Local includes.

#include "galleryconfig.h"
#include "galleries.h"

namespace KIPIGalleryExportPlugin
{

GalleryEdit::GalleryEdit(TQWidget* pParent,
                         Gallery* pGallery,
                         TQString title)
    : KDialogBase(pParent, 0, true, title, Ok|Cancel, Ok, false),
      mpGallery(pGallery)
{
  setButtonGuiItem( Ok, KStdGuiItem::save() );

  TQFrame *page = new TQFrame (this);
  TQHBoxLayout *tll = new TQHBoxLayout(page);
  page->setMinimumSize (500, 200);
  setMainWidget(page);

  TQVBoxLayout* vbox = new TQVBoxLayout();
  vbox->setSpacing (KDialog::spacingHint());
  tll->addItem(vbox);

  mpHeaderLabel = new TQLabel(page);
  mpHeaderLabel->setSizePolicy(TQSizePolicy(TQSizePolicy::Minimum,
                                            TQSizePolicy::Fixed));
  mpHeaderLabel->setText(title);
  vbox->addWidget(mpHeaderLabel);

  TQFrame* hline = new TQFrame(page, "hline");
  hline->setFrameShape(TQFrame::HLine);
  hline->setFrameShadow(TQFrame::Sunken);
  hline->setFrameShape(TQFrame::HLine);
  vbox->addWidget(hline);

  TQGridLayout* centerLayout = new TQGridLayout(0, 1, 1, 5, 5);

  mpNameEdit = new TQLineEdit( this );
  centerLayout->addWidget(mpNameEdit, 0, 1);

  mpUrlEdit = new TQLineEdit( this );
  centerLayout->addWidget(mpUrlEdit, 1, 1);

  mpUsernameEdit = new TQLineEdit( this );
  centerLayout->addWidget(mpUsernameEdit, 2, 1);

  mpPasswordEdit = new TQLineEdit( this );
  mpPasswordEdit->setEchoMode(TQLineEdit::Password);
  centerLayout->addWidget(mpPasswordEdit, 3, 1);

  TQLabel* name_label = new TQLabel(this);
  name_label->setText(i18n( "Name:" ));
  centerLayout->addWidget(name_label, 0, 0);

  TQLabel* urlLabel = new TQLabel(this);
  urlLabel->setText(i18n( "URL:" ));
  centerLayout->addWidget(urlLabel, 1, 0);

  TQLabel* nameLabel = new TQLabel(this);
  nameLabel->setText(i18n( "Username:" ));
  centerLayout->addWidget(nameLabel, 2, 0);

  TQLabel* passwdLabel = new TQLabel(this);
  passwdLabel->setText(i18n( "Password:" ));
  centerLayout->addWidget(passwdLabel, 3, 0);

  //---------------------------------------------
  mpGalleryVersion = new TQCheckBox( i18n("Use &Gallery 2"), this);
  mpGalleryVersion->setChecked( 2 == pGallery->version() );
  centerLayout->addWidget( mpGalleryVersion, 4, 1 );
  //---------------------------------------------

  vbox->addLayout( centerLayout );

  resize( TQSize(300, 150).expandedTo(minimumSizeHint()) );
  clearWState( WState_Polished );

  mpNameEdit->setText(pGallery->name());
  mpUrlEdit->setText(pGallery->url());
  mpUsernameEdit->setText(pGallery->username());
  mpPasswordEdit->setText(pGallery->password());
}

GalleryEdit::~GalleryEdit()
{

}

void GalleryEdit::slotOk(void)
{
  if (mpNameEdit->isModified())
    mpGallery->setName(mpNameEdit->text());
  if (mpUrlEdit->isModified())
    mpGallery->setUrl(mpUrlEdit->text());
  if (mpUsernameEdit->isModified())
    mpGallery->setUsername(mpUsernameEdit->text());
  if (mpPasswordEdit->isModified())
    mpGallery->setPassword(mpPasswordEdit->text());
  if (mpGalleryVersion->isChecked())
    mpGallery->setVersion(2);
  else
    mpGallery->setVersion(1);
  accept();
}

}

#include "galleryconfig.moc"

