/***************************************************************************
   begin                : Thu Apr 24 2003
   copyright            : (C) 2003 by Christian Hubinger
   email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NETFILTEROBJECT_H
#define NETFILTEROBJECT_H

// TQt includes
#include <tqobject.h>
#include <tqstring.h>
#include <tqdom.h>
#include <tqptrlist.h>
#include <tqintdict.h>
#include <tqmap.h>
#include <tquuid.h>
#include <tqstringlist.h>
#include <tqguardedptr.h>
#include <tdemacros.h>

// KDE includes

// Project includes

namespace KMF {
class KMFDoc;
class KMFUndoEngine;

/** NetfilterObject ist the base class for (allmost)  all data classes
	used within KMF. It defines the needed prperties and methods to 
	allow things undo/redo, unique object id's etc. */ 

class TDE_EXPORT NetfilterObject : public TQObject {

// friend class KMFNetwork;
friend class KMFUndoEngine;
friend class KMFTransaction;
friend class KMFProtocolCategory;

	//############# Beginn static stuff ##############

public:
	static NetfilterObject* findObject( const TQUuid& uuid );
	static int objectCount( int type );
private:	
	static TQMap<TQUuid, NetfilterObject*>* getUuidObjectDict() {
		return m_uuid_dict;
	};

// DATA
private:
	static TQMap<TQUuid, NetfilterObject*>* m_uuid_dict;
	
	//############# End static stuff ##############

public:
	NetfilterObject( NetfilterObject*,  const char* name );
	virtual ~NetfilterObject();
	
private:
	NetfilterObject();
	NetfilterObject( TQObject* );
	
public: 
	/** Known object types */ 
	enum { 
		TABLE = 0, 
		CHAIN = 1, 
		RULE = 2, 
		RULEOPTION = 3, 
		PROTOCOL = 4, 
		NETZONE = 5, 
		NETHOST = 6, 
		KMFTARGET = 7, 
		KMFTARGETCONFIG = 8, 
		PROTOCOLUSAGE = 9, 
		IPTABLES_RULESET = 10, 
		GENERIC_RULESET = 11, 
		KMFNETWORK = 12,
		PROTOCOLCATEGORY = 13 
	};
	
	/** Get All living objects of the given Type */
	// const TQValueList<NetfilterObject*>& getAllOfType( int type );
	
	/** Sets the Neame of the Object */
	virtual void setName( const TQString& );

	/** return the object uuid */
	const TQUuid& uuid() const {
		return m_uuid;
	};	

	/** Retrun the Object's name */
	virtual const TQString& name();


	/** reset type */
	virtual void clear() = 0;
	
	/** return the object type */
	virtual int type() = 0;
	
	/** Return the Object's nesting level within the NetfilterObject Tree */
	int getLevel();

	/** Return the Object's Description */
	virtual const TQString& description();

	/** Set Description for this Object */
	virtual void setDescription( const TQString& );

	/** Return DomDocument of this Object */
	virtual const TQDomDocument& getDOMTree() = 0;

	/** Return String representation of the DomDocument generated 
		by const TQDomDocument& getDOMTree() */
	virtual const TQString& getXMLSniplet();

	/** Load configuration from the given TQDdomDocument */
	virtual void loadXML( const TQDomDocument&, TQStringList& errors ) = 0;

	/** Load configuration from the given TQDdomDocument */
	virtual void loadXML( TQDomNode, TQStringList& errors ) = 0;
	
	/** Set the parent object */
	void setParent( NetfilterObject* );
	
	/** check if the object is a (indirect) child of the object 
		with the given id */
	bool isChildOf( const TQUuid& uuid );
	
	/** set the changed flag, and calling changed( int id ) in the parent 
		object with it's own id */
	void changed();
	
	/** Get the Parent object */
	NetfilterObject* parentObj() const {
		return m_parent;
	}
	
protected:
	/** read the uuid from the dom node if needed */
	void loadUuid( TQDomNode&, TQStringList& errors );
	
	/** write the uuid to the dom node */
	void saveUuid( TQDomNode& );
	
private:
	/** Return the Object's nesting level within the NetfilterObject Tree walking the tree up */
	void getLevel( int& currlevel );
	
	/** Sets the UUID of the Object */
	void setUuid( const TQUuid& );
	
private:
	TQGuardedPtr<NetfilterObject> m_parent;
	TQString m_name;
	TQString m_desc;
	TQUuid m_uuid;
};
}
#endif
