/***************************************************************************
                          knutprefdlg.cpp  -  description
                             -------------------
    begin                : Tue Aug 21 2001
    copyright            : (C) 2001 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knutprefdlg.h"
#include "knutvardata.h"
#include "knutfrontpanel.h"
#include "knutdock.h"

#include <kiconloader.h>

#include <tqlayout.h>
#include <tqgroupbox.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqfont.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqspinbox.h>


#include <stdio.h>
//#include <iostream>

#define MAIN_PANEL_FONT 0
#define ANALOG_PANEL_FONT 1



KNutPrefDlg::KNutPrefDlg(KNutUpsData* const upsData, KNutVarData* const analogData, KNutVarData::SettingDataDef* const settingData,
                          const TQString upsName, TQWidget* parent,  const char* name, const bool modal)
            :KDialogBase(IconList, i18n("Preferences"),Help|Default|Apply|Ok|Cancel,Ok, parent, name, modal, true),
                         m_activeUpsName (upsName), m_myUpsData(upsData), m_myAnalogData(analogData), m_settingData(settingData) {

  setName( "UpsMemberDlg" );

  m_checked = false; // no change of definition of UPS // neni zadna zmena na definici UPS
  m_checkedActiveUps = false; // change of active UPS hasn't been made // neni provedena zmena aktivni UPS

  initSetting();
  initUps();
  initPanel();
  initFonts();
  initAnalog();
  initDock(); // from 0.8 version
  setMinimumSize (450, 300);
  }


KNutPrefDlg::~KNutPrefDlg(){
  delete m_listBox2;
  }




/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE SLOTS                                                     */
/*                                                                                           */
/*********************************************************************************************/


void KNutPrefDlg::slotSetPictureKI (bool on) {
if (!on) {
  m_checkBoxCbi->setEnabled(true);
  m_iconDockLabel->setEnabled(true);
  m_BGIButton->setEnabled(m_checkBoxCbi->isChecked());
  m_dockBackgroundColorLabel->setEnabled(m_checkBoxCbi->isChecked());

  }
else {
  m_checkBoxCbi->setEnabled(false);
  m_iconDockLabel->setEnabled(false);
  m_BGIButton->setEnabled(false);
  m_dockBackgroundColorLabel->setEnabled(false);

  }

}

void KNutPrefDlg::slotEnableVoltage(bool enable) { m_voltageGroup->setEnabled(!enable);}

void KNutPrefDlg::slotEnableFrequency(bool enable) { m_frequencyGroup->setEnabled(!enable);}

void KNutPrefDlg::slotUseCustomBColor(bool enable) {
  m_BGButton->setEnabled(enable);
  m_mainBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBIconColor(bool enable) {
  m_BGIButton->setEnabled(enable);
  m_dockBackgroundColorLabel->setEnabled(enable);
  }


void KNutPrefDlg::slotUseCustomBPanelColor(bool enable) {
  m_BGPButton->setEnabled(enable);
  m_panelBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomBAnalogColor(bool enable) {
  m_BGAButton->setEnabled(enable);
  m_analogBackgroundColorLabel->setEnabled(enable);
  }

void KNutPrefDlg::slotUseCustomOAnalogColor(bool enable) {
  m_AFingerButton->setEnabled(enable);
  m_AOKButton->setEnabled(enable);
  m_AWarnningButton->setEnabled(enable);
  m_AErrorButton->setEnabled(enable);
  m_AScaleButton->setEnabled(enable);
  m_AFontButton->setEnabled(enable);
  m_analogPointerColorLabel->setEnabled(enable);
  m_analogOKColorLabel->setEnabled(enable);
  m_analogWarningColorLabel->setEnabled(enable);
  m_analogErrorColorLabel->setEnabled(enable);
  m_analogScaleColorLabel->setEnabled(enable);
  m_analogFontColorLabel->setEnabled(enable);
  }



void KNutPrefDlg::slotChangeSettingFont(int index) {
  if (m_settingFont != index) {
  // vybirame jiny font
  if (m_settingFont == MAIN_PANEL_FONT) {
     m_mPanelFont=m_fontWidget->font();
     m_fontWidget->setFont(m_aPanelFont);
    }
  else {
    m_aPanelFont=m_fontWidget->font();
    m_fontWidget->setFont(m_mPanelFont);
    }
   m_settingFont = index;
  }
}



void KNutPrefDlg::slotDeleteUps() {
  if (m_listBox2->currentItem() != -1)	{
    // smazeme policko
    int ukListBox = m_listBox2->currentItem();
    if ( m_activeUpsName == m_listBox2->currentText() ) m_checkedActiveUps = true;
    m_myUpsData->deleteName(ukListBox);
    m_listBox2->removeItem(ukListBox);
    m_checked = true;
    // when active ups is deleted, will set checkedActiveUps 
    // pokud smazeme aktivni UPS nastavime checkedActiveUps
    }
  }


void KNutPrefDlg::slotEditUps() {
  if (m_listBox2->currentItem() != -1)	{
    KNutUpsData::upsRecordDef upsRecord;
    // makes dialog
    newUpsDlg = new KNutNewUpsDlg(m_myUpsData,m_myAnalogData,false);
    // reads record
    m_myUpsData->get(m_listBox2->currentItem(),upsRecord);
    // sets parameters for edit /  nastavime parametry pro edit
    newUpsDlg->putData(upsRecord);
    int result = newUpsDlg->exec();
    if (result == Accepted) {
      // adds into list after OK will be clicked  
      // reads data from form
      upsRecord = newUpsDlg->getData();
      // corrects data in list
      m_myUpsData->put(m_listBox2->currentItem(),upsRecord);
      // corrects data in window
      m_listBox2->changeItem(upsRecord.name,m_listBox2->currentItem());
      m_checked = true;
      // if active UPS is changed, will set checkedActiveUps
      // pokud zmenime aktivni UPS nastavime checkedActiveUps
      if ( m_activeUpsName == m_listBox2->currentText() ) m_checkedActiveUps = true;
      }
    delete newUpsDlg;
    }
  }


void KNutPrefDlg::slotNewUps () {
  KNutUpsData::upsRecordDef upsRecord;
  // Zalozime novou UPS
  // add new UPS
  newUpsDlg = new KNutNewUpsDlg(m_myUpsData,m_myAnalogData);
  int result = newUpsDlg->exec();
  if (result == Accepted) {
    // adds into list, when OK is pressed
    //reads data from form
    upsRecord = newUpsDlg->getData();
    //pridame data do zaznamu
    //adds data to record
    m_myUpsData->add(upsRecord);
    //add data to window
    // pridame data do okenka
    m_listBox2->insertItem(upsRecord.name);
    // pokud pridame prvni prekreslime hlavni okno
    // when adds the first sameone, will repaint window
    m_checked = true;
    if (m_myUpsData->getCount() ==1 ) m_checkedActiveUps = true;
    }
  delete newUpsDlg;
  }


void KNutPrefDlg::slotOk() {
  slotApply ();
  accept();
  }

void KNutPrefDlg::slotApply() {
// budeme emitovat signal podle toho co se deje
// will emit signal about situation
  unsigned int changeSetting = 0;

 // MainPage
  if (m_settingData->countCols != m_numberOfColumns->value()) {
    changeSetting += ChangeCountCols;  // nastavime pocet sloupcu
    m_settingData->countCols = m_numberOfColumns->value();  // nastavime pocet sloupcu
    }

  if (m_settingData->customBColor != m_checkBoxCbc->isChecked()) {
    m_settingData->customBColor = m_checkBoxCbc->isChecked();
    changeSetting += ChangeCustomBColor;
    }

  if (m_settingData->mainBackgroundColor != m_BGButton->color()) {
    changeSetting += ChangeMBColor;
    m_settingData->mainBackgroundColor = m_BGButton->color();  // nastavime barvu pozadi
    }

  // ovlivnuje jen ukonceni programu, neurcujeme type ChangeSetting
  if (m_settingData->areYouSure != m_checkBoxAys->isChecked()) {
    m_settingData->areYouSure = m_checkBoxAys->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }

  //for next start only
  if (m_comboBoxMainWindow->currentItem() != (int)m_settingData->useMainWindow) {
    m_settingData->useMainWindow = (KNutVarData::mainWindowStartVariant)m_comboBoxMainWindow->currentItem();
    changeSetting = changeSetting | ChangeSomeThing;
   }

//  if (m_prefData->useMainWindow != m_checkBoxMW->isChecked()) {
//    m_prefData->useMainWindow = m_checkBoxMW->isChecked();
//    changeSetting = changeSetting | ChangeSomeThing;
//    }
  //for next start only
  if (m_settingData->useMessageWindow != m_checkBoxMesW->isChecked()) {
    m_settingData->useMessageWindow = m_checkBoxMesW->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }

  //for next start only
  if (m_settingData->useMessageWindow != m_checkBoxMesW->isChecked()) {
    m_settingData->useMessageWindow = m_checkBoxMesW->isChecked();
    changeSetting = changeSetting | ChangeSomeThing;
    }


  int newInputVoltage, newInputFrequency;
  if ( m_vRadioButton1->isChecked()) newInputVoltage = 230; else newInputVoltage = 120;
  if ( m_fRadioButton1->isChecked()) newInputFrequency = 50; else newInputFrequency = 60;

  if (m_settingData->inputVoltage != newInputVoltage) {
    m_settingData->inputVoltage = newInputVoltage;
    changeSetting += ChangeVoltage;
    }

  if (m_settingData->inputFrequency != newInputFrequency) {
    m_settingData->inputFrequency = newInputFrequency;
    changeSetting += ChangeFrequency;
    }

 if (m_settingData->lowHighXfer != m_xfer->isChecked()) changeSetting += ChangeXFer;
   m_settingData->lowHighXfer = m_xfer->isChecked();

    //Ups page
  if ( m_checkedActiveUps ) { // zmena aktivni UPS
    //change of active UPS or add the first UPS, because the first UPS is active always
    changeSetting += ChangeUpsSetting;
    }
  else {
    if (m_checked) changeSetting += ChangeUpsCount;
    }
  // panel Page
  unsigned int prefPanelFlags = 3;
  if (m_checkBoxOver->isChecked()) prefPanelFlags += KNutFrontPanel::PBOver;
  if (m_checkBoxBL->isChecked()) prefPanelFlags += KNutFrontPanel::PBBattLow;
  if (m_checkBoxRB->isChecked()) prefPanelFlags += KNutFrontPanel::PBRepBatt;
  if (m_checkBoxCal->isChecked()) prefPanelFlags += KNutFrontPanel::PBCal;
  if (m_checkBoxMFRM->isChecked()) prefPanelFlags += KNutFrontPanel::PBMFRMod;
  if (m_checkBoxMFR->isChecked()) prefPanelFlags += KNutFrontPanel::PBMFR;
  if (m_checkBoxModel->isChecked()) prefPanelFlags += KNutFrontPanel::PBModel;
  if (m_checkBoxSerial->isChecked()) prefPanelFlags += KNutFrontPanel::PBSerial;
  if (m_checkBoxFirm->isChecked()) prefPanelFlags += KNutFrontPanel::PBFirm;
  if (m_checkBoxRun->isChecked()) prefPanelFlags += KNutFrontPanel::PBRun;

  if (m_settingData->panelFlags != prefPanelFlags) {
    m_settingData->panelFlags = prefPanelFlags;
    changeSetting += ChangeMainPanelSetting;
    }

  if (m_settingData->customBPanelColor != m_checkBoxCbpc->isChecked()) {
    m_settingData->customBPanelColor = m_checkBoxCbpc->isChecked();
    changeSetting += ChangeCustomMPanelBColor;
    }

  if (m_settingData->mPanelBackgroundColor != m_BGPButton->color()) {
    changeSetting += ChangeMPBColor;
    m_settingData->mPanelBackgroundColor = m_BGPButton->color();  // sets color of background
    }


    // font Page:
    unsigned int changeFonts;
    changeFonts =0;

    if (m_settingFont == MAIN_PANEL_FONT)
      m_mPanelFont=m_fontWidget->font();
    else
      m_aPanelFont=m_fontWidget->font();

    if ( m_customFont->isChecked() != m_settingData->customFont) {
      // zmena typy fontu systemove <-> uzivatelske
       m_settingData->customFont = m_customFont->isChecked();
       if (m_settingData->customFont) {
         // prejdeme na uzivatelske fonty
         m_settingData->aPanelFont = m_aPanelFont;
         m_settingData->mPanelFont = m_mPanelFont;
         changeSetting += ChangeAnalogFont;
         changeSetting += ChangePanelFont;
         }
       else {
         // pouzijeme systemove fonty
         changeSetting += ChangeAnalogFont;
         changeSetting += ChangePanelFont;
         }
      }
    else {
      if ( m_settingData->customFont ) {
        // otestujeme zda se zmenili nase fonty
        if (m_aPanelFont != m_settingData->aPanelFont) {
          m_settingData->aPanelFont = m_aPanelFont;
          changeSetting += ChangeAnalogFont;
          }
        if (m_mPanelFont != m_settingData->mPanelFont) {
          m_settingData->mPanelFont = m_mPanelFont;
          changeSetting += ChangePanelFont;
          }
        }
      }
  // analog page

  if (m_settingData->customBAnalogColor != m_checkBoxCbac->isChecked()) {
    m_settingData->customBAnalogColor = m_checkBoxCbac->isChecked();
    changeSetting += ChangeCustomAPanelBColor;
    }

  if (m_settingData->aPanelBackgroundColor != m_BGAButton->color()) {
    changeSetting += ChangeAPBColor;
    m_settingData->aPanelBackgroundColor = m_BGAButton->color();  // nastavime barvu pozadi
    }

  if (m_settingData->customOAnalogColor != m_checkBoxCoac->isChecked()) {
    m_settingData->customOAnalogColor = m_checkBoxCoac->isChecked();
    changeSetting += ChangeCustomAPanelOColor;
    }

  if ((m_settingData->analogFingerColor != m_AFingerButton->color()) ||
      (m_settingData->analogOKColor != m_AOKButton->color()) ||
      (m_settingData->analogWarnningColor != m_AWarnningButton->color()) ||
      (m_settingData->analogErrorColor != m_AErrorButton->color()) ||
      (m_settingData->analogScaleColor != m_AScaleButton->color()) ||
      (m_settingData->analogFontColor != m_AFontButton->color())) {
    changeSetting += ChangeAPOColor;
    m_settingData->analogFingerColor = m_AFingerButton->color();  // sets color of pointers-- nastavime barvu rucicky
    m_settingData->analogOKColor = m_AOKButton->color();  // sets color of OK --  nastavime barvu ok
    m_settingData->analogWarnningColor = m_AWarnningButton->color();  // nastavime barvu varovano
    m_settingData->analogErrorColor = m_AErrorButton->color();  // nastavime barvu chyby
    m_settingData->analogScaleColor = m_AScaleButton->color();  // nastavime barvu stupnice
    m_settingData->analogFontColor = m_AFontButton->color();  // nastavime barvu textu
    }

  if (m_settingData->typeDigitalProcessing != m_digitalProcesingOfPointers->currentItem()) {
    m_settingData->typeDigitalProcessing = m_digitalProcesingOfPointers->currentItem();
    changeSetting += ChangeTypeOfDigProcessing;
    }

  // Kicker Icon page

  int stateTDEIcon;
  if (m_iconRadioButton1->isChecked()) stateTDEIcon = KNutDock::pictureKI;
  else stateTDEIcon = KNutDock::generalKI;
  if (m_settingData->typeOfTDEIcon != stateTDEIcon) {
    if (m_iconRadioButton1->isChecked()) m_settingData->typeOfTDEIcon = KNutDock::pictureKI;
    if (m_iconRadioButton2->isChecked()) m_settingData->typeOfTDEIcon = KNutDock::generalKI;
    changeSetting += ChangeTypeOfTDEIcon;
    }

  if (m_settingData->customTDEIconColor != m_checkBoxCbi->isChecked()) {
    m_settingData->customTDEIconColor = m_checkBoxCbi->isChecked();
    changeSetting += ChangeCustomTDEIconColor;
    }

  if (m_settingData->kIconBackgroundColor != m_BGIButton->color()) {
    changeSetting += ChangeTDEIconBColor;
    m_settingData->kIconBackgroundColor = m_BGIButton->color();  // nastavime barvu pozadi
    }

  unsigned int prefToolTipFlags = 0;
  if (m_checkBoxTTMFR->isChecked()) prefToolTipFlags += KNutDock::TTMFR;
  if (m_checkBoxTTModel->isChecked()) prefToolTipFlags += KNutDock::TTModel;
  if (m_checkBoxTTSerial->isChecked()) prefToolTipFlags += KNutDock::TTSerial;
  if (m_checkBoxTTFirm->isChecked()) prefToolTipFlags += KNutDock::TTFirm;
  if (m_checkBoxTTRun->isChecked()) prefToolTipFlags += KNutDock::TTRun;
  if (m_checkBoxTTCharge->isChecked()) prefToolTipFlags += KNutDock::TTCharge;
  if (m_checkBoxTTLoad->isChecked()) prefToolTipFlags += KNutDock::TTLoad;

  if (m_settingData->toolTipFlags != prefToolTipFlags) {
    m_settingData->toolTipFlags = prefToolTipFlags;
    changeSetting += ChangeToolTip;
    }

  if (changeSetting)  emit signalChangeConfig( changeSetting );
  }


void KNutPrefDlg::slotDefault() {
  switch (activePageIndex()) {
    case mainSettingPage:
      m_numberOfColumns->setValue( knc::DefaultCountCols );
      m_BGButton->setColor(DEFAULT_BG_COLOR);
      m_checkBoxAys->setChecked ( false );
      m_checkBoxMesW->setChecked ( false );
      m_comboBoxMainWindow->setCurrentItem(KNutVarData::mw_no); // sets NO
      m_vRadioButton1->setChecked( true );
      m_fRadioButton1->setChecked( true );
      m_xfer->setChecked( false );
      break;
    case panelSettingPage:
      m_checkBoxOver->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBOver);
      m_checkBoxBL->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBBattLow);
      m_checkBoxRB->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBRepBatt);
      m_checkBoxCal->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBCal);
      m_checkBoxMFRM->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBMFRMod);
      m_checkBoxMFR->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBMFR);
      m_checkBoxModel->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBModel);
      m_checkBoxSerial->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBSerial);
      m_checkBoxFirm->setChecked(KNutFrontPanel::DefaultPanelFlags & KNutFrontPanel::PBFirm);
      m_checkBoxCbpc->setChecked(false);
      m_BGAButton->setColor(DEFAULT_BG_COLOR);
      break;
   case fontSettingPage:
      m_customFont->setChecked(false);
      break;
   case analogSettingPage:
      m_checkBoxCbac->setChecked(false);
      m_BGAButton->setColor(DEFAULT_BG_COLOR);
      m_checkBoxCoac->setChecked(false);
      m_AFingerButton->setColor(DEFAULT_FINGER_COLOR);
      m_AOKButton->setColor(DEFAULT_OK_COLOR);
      m_AWarnningButton->setColor(DEFAULT_WARNNING_COLOR);
      m_AErrorButton->setColor(DEFAULT_ERROR_COLOR);
      m_AScaleButton->setColor(DEFAULT_SCALE_COLOR);
      m_AFontButton->setColor(DEFAULT_FONT_COLOR);
      break;
   case kickerSettingPage:
      m_checkBoxCbi->setChecked(false);
      m_BGAButton->setColor(DEFAULT_KICON_COLOR);
      m_checkBoxTTMFR->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTMFR);
      m_checkBoxTTModel->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTModel);
      m_checkBoxTTSerial->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTSerial);
      m_checkBoxTTFirm->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTFirm);
      m_checkBoxTTRun->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTRun);
      m_checkBoxTTCharge->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTCharge);
      m_checkBoxTTLoad->setChecked(KNutDock::DefaultToolTipFlags & KNutDock::TTLoad);
      m_iconRadioButton1->setChecked( true );
      break;
    }
  }

/*********************************************************************************************/
/*                                                                                           */
/*                         PRIVATE FUNCTIONS                                                 */
/*                                                                                           */
/*********************************************************************************************/

void KNutPrefDlg::initSetting () {
  m_mSetPix = UserIcon ("knc_mset");


  TQFrame *page = addPage( i18n("Setting"),i18n("Main Setting"),m_mSetPix);
  TQVBoxLayout *setTopLayout = new TQVBoxLayout( page, 10, spacingHint (), "setTopLayout" );

  TQGroupBox *dataBox = new TQGroupBox (page ,"dataBox");
  TQGridLayout *dataLayout = new TQGridLayout (dataBox,5,2,spacingHint());
  dataBox->setFrameStyle(TQFrame::NoFrame);
  setTopLayout->addWidget(dataBox);

  TQButtonGroup *VFGroup = new TQButtonGroup(i18n("Voltage/Frequency"),page,"VFGroup");
  TQGridLayout *setVoltFreqLayout = new TQGridLayout (VFGroup, 4 , 2,spacingHint () );

  m_xfer = new TQCheckBox (i18n("&Use High-Low XFER"),VFGroup,"m_xfer");

  TQLabel *initSettingLabel1 = new TQLabel(i18n("Number of columns :"),dataBox,"label1");
  m_numberOfColumns = new TQSpinBox(knc::MinCols,knc::MaxCols,1,dataBox);

  TQLabel *initSettingLabel2 = new TQLabel(i18n("Use custom background color"),dataBox,"label2");
  m_checkBoxCbc = new TQCheckBox ("",dataBox,"checboxcbc");


  m_mainBackgroundColorLabel = new TQLabel(i18n("Color of background :"),dataBox,"label3");
  m_BGButton = new KColorButton (dataBox);
  m_BGButton->setColor (m_settingData->mainBackgroundColor);

  TQLabel *initSettingLabel4 = new TQLabel(i18n("Use dialog \"Are you sure\""),dataBox,"m_areYouSureLabel");
  m_checkBoxAys = new TQCheckBox ("",dataBox,"checboxays");

  TQLabel *initSettingLabel5 = new TQLabel(i18n("Use Main window when program is started"),dataBox,"initSettingLabel5");
//  m_checkBoxMW = new TQCheckBox ("",dataBox,"checboxmv");

  TQLabel *initSettingLabel6 = new TQLabel(i18n("Show message window, when program reports error"),dataBox,"initSettingLabel6");
  m_checkBoxMesW = new TQCheckBox ("",dataBox,"checboxer");
  m_comboBoxMainWindow = new KComboBox (dataBox);
  m_comboBoxMainWindow->insertItem (i18n("Yes"));
  m_comboBoxMainWindow->insertItem (i18n("No"));
  m_comboBoxMainWindow->insertItem (i18n("Auto"));



  m_voltageGroup = new TQButtonGroup(i18n("Nominal Input Voltage"),VFGroup,"voltageGroup");
  TQGridLayout *voltLayout = new TQGridLayout (m_voltageGroup, 3 , 1,spacingHint () );

  m_vRadioButton1 = new TQRadioButton(i18n("&230 V"), m_voltageGroup, "vRadioButton1" );
  m_vRadioButton2 = new TQRadioButton(i18n("&120 V"), m_voltageGroup, "vRadioButton2" );

  m_frequencyGroup = new TQButtonGroup(i18n("Nominal Input Frequency"),VFGroup,"frequencyGroup");
  TQGridLayout *freqLayout = new TQGridLayout (m_frequencyGroup, 3 , 1,spacingHint () );

  m_fRadioButton1 = new TQRadioButton(i18n("&50 Hz"), m_frequencyGroup, "fRadioButton1" );
  m_fRadioButton2 = new TQRadioButton(i18n("&60 Hz"), m_frequencyGroup, "fRadioButton2" );

  dataLayout->addWidget (initSettingLabel1,0,0);
  dataLayout->addWidget (m_numberOfColumns,0,1);

  dataLayout->addWidget (initSettingLabel2,1,0);
  dataLayout->addWidget (m_checkBoxCbc,1,1);

  dataLayout->addWidget (m_mainBackgroundColorLabel,2,0);
  dataLayout->addWidget (m_BGButton,2,1);

  dataLayout->addWidget (initSettingLabel4,3,0);
  dataLayout->addWidget (m_checkBoxAys,3,1);

  dataLayout->addWidget (initSettingLabel5,4,0);
  dataLayout->addWidget (m_comboBoxMainWindow,4,1);

  dataLayout->addWidget (initSettingLabel6,5,0);
  dataLayout->addWidget (m_checkBoxMesW,5,1);

  dataLayout->setColStretch(1,5);

  voltLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  voltLayout->addWidget ( m_vRadioButton1,1,0 );
  voltLayout->addWidget ( m_vRadioButton2,2,0 );

  freqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  freqLayout->addWidget ( m_fRadioButton1,1,0 );
  freqLayout->addWidget ( m_fRadioButton2,2,0 );

  setTopLayout->addWidget (VFGroup,10);
  setVoltFreqLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  setVoltFreqLayout->addWidget ( m_voltageGroup,1,0 );
  setVoltFreqLayout->addWidget ( m_frequencyGroup,1,1 );
  setVoltFreqLayout->addWidget ( m_xfer,2,0 );
  setVoltFreqLayout->addRowSpacing (3 ,fontMetrics().lineSpacing() );

  setTopLayout->addStretch( 20 );

  //sets value
  m_numberOfColumns->setValue(m_settingData->countCols);
  m_BGButton->setColor(m_settingData->mainBackgroundColor);  // sets color of backgound
  m_checkBoxAys->setChecked(m_settingData->areYouSure);
  m_checkBoxMesW->setChecked(m_settingData->useMessageWindow);
  m_comboBoxMainWindow->setCurrentItem(m_settingData->useMainWindow);

  if (m_settingData->inputVoltage == 230)
    m_vRadioButton1->setChecked( true );
  else
    m_vRadioButton2->setChecked( true );
  if (m_settingData->inputFrequency == 50)
    m_fRadioButton1->setChecked( true );
  else
   m_fRadioButton2->setChecked( true );

  m_xfer->setChecked(m_settingData->lowHighXfer);
  m_voltageGroup->setEnabled(!m_settingData->lowHighXfer);
  m_frequencyGroup->setEnabled(!m_settingData->lowHighXfer);
  connect (m_xfer,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotEnableVoltage(bool)));
  connect (m_xfer,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotEnableFrequency(bool)));


  m_checkBoxCbc->setChecked(m_settingData->customBColor); 
  m_BGButton->setColor(m_settingData->mainBackgroundColor);
  m_BGButton->setEnabled(m_settingData->customBColor);
  m_mainBackgroundColorLabel->setEnabled(m_settingData->customBColor);
  connect (m_checkBoxCbc,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotUseCustomBColor(bool)));
  }

void KNutPrefDlg::initUps () {
  m_upsesPix = UserIcon ("knc_upses");
  TQFrame *page = addPage( i18n("UPS"),i18n("UPS Setting"),m_upsesPix);
  TQHBoxLayout *upsTopLayout = new TQHBoxLayout( page, 0, spacingHint (),"upsTopLayout" );

  // makes box for names of UPS's / Vytvorime box pro jmena UPS-ek
  m_listBox2 = new TDEListBox( page, "ListBox2" );
  m_listBox2->setSizePolicy( TQSizePolicy( (TQSizePolicy::SizeType)5, (TQSizePolicy::SizeType)5, m_listBox2->sizePolicy().hasHeightForWidth() ) );
  m_listBox2->setFrameShape( TQListBox::StyledPanel );
  m_listBox2->setFrameShadow( TQListBox::Sunken );
  m_listBox2->setMinimumSize (100,100);

  // sets listbox
  for (int i=0; i < m_myUpsData->getCount (); i++) m_listBox2->insertItem (m_myUpsData->getName(i));
  //includes listbox into horizontal layout on the first place
  upsTopLayout->addWidget( m_listBox2, 20 );
  // makes vertical layout and includes it in horizontal layout into the second place 
  TQVBoxLayout *upsLayout = new TQVBoxLayout( upsTopLayout, spacingHint (),"upsLayout" );

  // vytvorime tlacitka
  KPushButton *newButton = new KPushButton (i18n("&Add"),page);
  KPushButton *editButton = new KPushButton (i18n("&Edit"),page);
  KPushButton *deleteButton = new KPushButton (i18n("&Delete"),page);

  // includes buttons into layout /  vlozime tlacitka do layoutu
  upsLayout->addWidget( newButton );
  upsLayout->addWidget( editButton );
  upsLayout->addWidget( deleteButton );

  upsLayout->addStretch( 10 );

  connect (newButton,TQ_SIGNAL(clicked()),this,TQ_SLOT(slotNewUps()));
  connect (editButton,TQ_SIGNAL(clicked()),this,TQ_SLOT(slotEditUps()));
  connect (deleteButton,TQ_SIGNAL(clicked()),this,TQ_SLOT(slotDeleteUps()));
  connect (m_listBox2,TQ_SIGNAL(doubleClicked(TQListBoxItem*, const TQPoint&)),this,TQ_SLOT(slotEditUps()));

  }

void KNutPrefDlg::initDock () {

  m_dockPix = UserIcon ("knc_dock");
  TQFrame *page = addPage( i18n("Dock bar"),i18n("Docking Setting"),m_dockPix);

  TQVBoxLayout *setTopLayout = new TQVBoxLayout( page, 10, spacingHint (), "setTopLayout" );

  TQButtonGroup *typeGroup = new TQButtonGroup(i18n("Type of dock's showing"),page,"typeGroup");
  TQGridLayout *typeLayout = new TQGridLayout (typeGroup,2,2,spacingHint());
  setTopLayout->addWidget(typeGroup);


  TQGroupBox *infoBox = new TQGroupBox (i18n("Items of tooltip"),page ,"infoBox");
  TQGridLayout *infoLayout = new TQGridLayout (infoBox,8,1,spacingHint());
  setTopLayout->addWidget(infoBox);

  TQGridLayout *colorLayout = new TQGridLayout (10,1,spacingHint(),"colorLayout");
  setTopLayout->addLayout(colorLayout);


  m_iconRadioButton1 = new TQRadioButton(i18n("&Picture"), typeGroup, "iconRadioButton1" );
  m_iconRadioButton2 = new TQRadioButton(i18n("&General"), typeGroup, "iconRadioButton2" );


  m_checkBoxTTMFR = new TQCheckBox (i18n("M&anufacturer"),infoBox);
  m_checkBoxTTMFR->setChecked((m_settingData->toolTipFlags) & KNutDock::TTMFR);

  m_checkBoxTTModel = new TQCheckBox (i18n("M&odel"),infoBox);
  m_checkBoxTTModel->setChecked((m_settingData->toolTipFlags) & KNutDock::TTModel);

  m_checkBoxTTSerial = new TQCheckBox (i18n("&Serial"),infoBox);
  m_checkBoxTTSerial->setChecked((m_settingData->toolTipFlags) & KNutDock::TTSerial);

  m_checkBoxTTFirm = new TQCheckBox (i18n("&Firm. rev."),infoBox);
  m_checkBoxTTFirm->setChecked((m_settingData->toolTipFlags) & KNutDock::TTFirm);

  m_checkBoxTTRun = new TQCheckBox (i18n("&Runtime"),infoBox);
  m_checkBoxTTRun->setChecked((m_settingData->toolTipFlags) & KNutDock::TTRun);

  m_checkBoxTTCharge = new TQCheckBox (i18n("&Battery Charge"),infoBox);
  m_checkBoxTTCharge->setChecked((m_settingData->toolTipFlags) & KNutDock::TTCharge);

  m_checkBoxTTLoad = new TQCheckBox (i18n("&UPS Load"),infoBox);
  m_checkBoxTTLoad->setChecked((m_settingData->toolTipFlags) & KNutDock::TTLoad);


  m_iconDockLabel = new TQLabel(i18n("Use custom icon's background color"),page,"label1");
  m_checkBoxCbi = new TQCheckBox ("",page,"checboxcbpc");

  m_dockBackgroundColorLabel = new TQLabel(i18n("Color of icon's background :"),page,"label12");
  m_BGIButton = new KColorButton (page);

  typeLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  typeLayout->addWidget ( m_iconRadioButton1,1,0 );
  typeLayout->addWidget ( m_iconRadioButton2,2,0 );

  if (m_settingData->typeOfTDEIcon == KNutDock::pictureKI)
    m_iconRadioButton1->setChecked( true );
  if (m_settingData->typeOfTDEIcon == KNutDock::generalKI)
    m_iconRadioButton2->setChecked( true );

  infoLayout->addRowSpacing (0 ,fontMetrics().lineSpacing() );
  infoLayout->addWidget ( m_checkBoxTTMFR ,1,0);
  infoLayout->addWidget ( m_checkBoxTTModel ,2,0);
  infoLayout->addWidget ( m_checkBoxTTSerial ,3,0);
  infoLayout->addWidget ( m_checkBoxTTFirm ,4,0);
  infoLayout->addWidget ( m_checkBoxTTRun ,5,0);
  infoLayout->addWidget ( m_checkBoxTTCharge ,6,0);
  infoLayout->addWidget ( m_checkBoxTTLoad ,7,0);

  colorLayout->addWidget (m_iconDockLabel,0,0);
  colorLayout->addWidget (m_checkBoxCbi,0,1);
  colorLayout->addWidget (m_dockBackgroundColorLabel,1,0);
  colorLayout->addWidget (m_BGIButton,1,1);

  m_checkBoxCbi->setChecked(m_settingData->customTDEIconColor);
  m_BGIButton->setColor(m_settingData->kIconBackgroundColor);
//  m_BGIButton->setEnabled(m_prefData->customTDEIconColor);
//  m_dockBackgroundColorLabel->setEnabled(m_prefData->customTDEIconColor);

  if (m_iconRadioButton1->isChecked()) {
    m_iconDockLabel->setEnabled(false);
    m_checkBoxCbi->setEnabled(false);
    m_BGIButton->setEnabled(false);
    m_dockBackgroundColorLabel->setEnabled(false);
    }
  else {
    m_iconDockLabel->setEnabled(true);
    m_BGIButton->setEnabled(m_settingData->customTDEIconColor);
    m_dockBackgroundColorLabel->setEnabled(m_settingData->customTDEIconColor);
    }

  setTopLayout->addStretch( 20 );

  connect (m_checkBoxCbi,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotUseCustomBIconColor(bool)));
  connect (m_iconRadioButton1,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotSetPictureKI(bool)));

  }


void KNutPrefDlg::initPanel () {

  m_panelPix = UserIcon ("knc_panel");

//  TQFrame *page = addPage( i18n("Panel"),i18n("Panel Setting"),DesktopIcon("panel_settings"));
  TQFrame *page = addPage( i18n("Panel"),i18n("Panel Setting"),m_panelPix);

  TQVBoxLayout *setTopLayout = new TQVBoxLayout( page, 10, spacingHint (), "setTopLayout" );


  TQGroupBox *infoBox = new TQGroupBox (page ,"infoBox");
  TQGridLayout *infoLayout = new TQGridLayout (infoBox,10,1,spacingHint());
  setTopLayout->addWidget(infoBox);

  TQGridLayout *colorLayout = new TQGridLayout (10,1,spacingHint(),"colorLayout");
  setTopLayout->addLayout(colorLayout);


  // vytvorime widgety - Nazev Zatrhavaci box
  //makes widgets - name checkbox
  m_checkBoxOver = new TQCheckBox (i18n("UPS &Overload"),infoBox);
  m_checkBoxOver->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBOver);

  m_checkBoxBL = new TQCheckBox (i18n("UPS &Battery low"),infoBox);
  m_checkBoxBL->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBBattLow);

  m_checkBoxRB = new TQCheckBox (i18n("R&eplace battery"),infoBox);
  m_checkBoxRB->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBRepBatt);

  m_checkBoxCal = new TQCheckBox (i18n("Ups &calibration"),infoBox);
  m_checkBoxCal->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBCal);

  m_checkBoxMFRM = new TQCheckBox (i18n("&Manufac. + Model"),infoBox);
  m_checkBoxMFRM->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBMFRMod);

  m_checkBoxMFR = new TQCheckBox (i18n("M&anufacturer"),infoBox);
  m_checkBoxMFR->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBMFR);

  m_checkBoxModel = new TQCheckBox (i18n("M&odel"),infoBox);
  m_checkBoxModel->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBModel);

  m_checkBoxSerial = new TQCheckBox (i18n("&Serial"),infoBox);
  m_checkBoxSerial->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBSerial);

  m_checkBoxFirm = new TQCheckBox (i18n("&Firm. rev."),infoBox);
  m_checkBoxFirm->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBFirm);

  m_checkBoxRun = new TQCheckBox (i18n("&Runtime"),infoBox);
  m_checkBoxRun->setChecked((m_settingData->panelFlags) & KNutFrontPanel::PBRun);


  TQLabel *initPanelLabel1 = new TQLabel(i18n("Use custom background color"),page,"label1");
  m_checkBoxCbpc = new TQCheckBox ("",page,"checboxcbpc");

  m_panelBackgroundColorLabel = new TQLabel(i18n("Color of background :"),page,"m_panelBackgroundColorLabel");
  m_BGPButton = new KColorButton (page);

  // includes widgets
  infoLayout->addWidget ( m_checkBoxOver, 0,0);
  infoLayout->addWidget ( m_checkBoxBL ,1,0);
  infoLayout->addWidget ( m_checkBoxRB ,2,0);
  infoLayout->addWidget ( m_checkBoxCal ,3,0);
  infoLayout->addWidget ( m_checkBoxMFRM ,4,0);
  infoLayout->addWidget ( m_checkBoxMFR ,5,0);
  infoLayout->addWidget ( m_checkBoxModel ,6,0);
  infoLayout->addWidget ( m_checkBoxSerial ,7,0);
  infoLayout->addWidget ( m_checkBoxFirm ,8,0);
  infoLayout->addWidget ( m_checkBoxRun ,9,0);

  colorLayout->addWidget (initPanelLabel1,0,0);
  colorLayout->addWidget (m_checkBoxCbpc,0,1);
  colorLayout->addWidget (m_panelBackgroundColorLabel,1,0);
  colorLayout->addWidget (m_BGPButton,1,1);

  setTopLayout->addStretch( 20 );

  m_checkBoxCbpc->setChecked(m_settingData->customBPanelColor);
  m_BGPButton->setColor(m_settingData->mPanelBackgroundColor);
  m_BGPButton->setEnabled(m_settingData->customBPanelColor);
  m_panelBackgroundColorLabel->setEnabled(m_settingData->customBPanelColor);
  m_panelBackgroundColorLabel->setEnabled(m_settingData->customBPanelColor);
  connect (m_checkBoxCbpc,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotUseCustomBPanelColor(bool)));

  }


void KNutPrefDlg::initFonts () {
  TQFrame *page = addPage( i18n("Fonts"),i18n("Setting Fonts"),DesktopIcon("fonts"));

  TQVBoxLayout *setTopLayout = new TQVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  TQHBoxLayout *setSysLayout = new TQHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  TQHBoxLayout *setTypeLayout = new TQHBoxLayout( setTopLayout, spacingHint (), "setTypeLayout" );
  TQHBoxLayout *setFontLayout = new TQHBoxLayout( setTopLayout, spacingHint (), "setFontLayout" );

  m_customFont = new TQCheckBox (i18n("&Use custom font"),page);
  setSysLayout->addWidget ( m_customFont ,10);
  setSysLayout->addStretch( 10 );

  KComboBox *panelFonts = new KComboBox(page);
  panelFonts->insertItem (i18n("Main panel"));
  panelFonts->insertItem (i18n("Analog panels"));
  setTypeLayout->addWidget ( panelFonts ,0);



  m_fontWidget = new TDEFontChooser(page,"Font",false);
  setFontLayout->addWidget (m_fontWidget ,0);

  setTopLayout->addStretch( 20 );

// init items
  m_customFont->setChecked(m_settingData->customFont);
  m_aPanelFont = m_settingData->aPanelFont;
  m_mPanelFont = m_settingData->mPanelFont;
  m_settingFont = MAIN_PANEL_FONT; // sets font for Main Panel /  nastavujeme font pro Main Panel
  m_fontWidget->setFont(m_mPanelFont);
  m_fontWidget->setEnabled(m_settingData->customFont);
  connect (panelFonts,TQ_SIGNAL(activated(int)),this,TQ_SLOT(slotChangeSettingFont(int)));
  connect (m_customFont,TQ_SIGNAL(toggled(bool)),m_fontWidget,TQ_SLOT(setEnabled(bool)));
  }

void KNutPrefDlg::initAnalog () {
  m_analogPix = UserIcon ("knc_analog");
  TQFrame *page = addPage( i18n("Analog"),i18n("Setting Analog panel"),m_analogPix);
//  TQFrame *page = addPage( i18n("Analog"),i18n("Setting Analog panel"),DesktopIcon("ksysguard"));
  TQVBoxLayout *setTopLayout = new TQVBoxLayout( page, 10, spacingHint (), "setTopLayout" );
  TQGridLayout *setColorLayout = new TQGridLayout( 9,2, spacingHint(),"setColorLayout");
  setTopLayout->addLayout(setColorLayout);
  setTopLayout->addStretch( 20 );

  TQLabel *initAnalogLabel1 = new TQLabel(i18n("Use custom background color"),page,"initAnalogLabel1");
  m_checkBoxCbac = new TQCheckBox ("",page,"checboxcbac");
  m_analogBackgroundColorLabel = new TQLabel(i18n("Color of background :"),page,"m_backgroundColorLabel");
  m_BGAButton = new KColorButton (page);
  TQLabel *initAnalogLabel12 = new TQLabel(i18n("Use custom other colors"),page,"label12");
  m_checkBoxCoac = new TQCheckBox ("",page,"checboxcoac");
  m_analogPointerColorLabel = new TQLabel(i18n("Color of pointer :"),page,"m_analogPointerColorLabel");
  m_AFingerButton = new KColorButton (page);
  m_analogOKColorLabel = new TQLabel(i18n("Color of OK range :"),page,"label7");
  m_AOKButton = new KColorButton (page);
  m_analogWarningColorLabel = new TQLabel(i18n("Color of warning range :"),page,"label8");
  m_AWarnningButton = new KColorButton (page);
  m_analogErrorColorLabel= new TQLabel(i18n("Color of error range :"),page,"label9");
  m_AErrorButton = new KColorButton (page);
  m_analogScaleColorLabel = new TQLabel(i18n("Color of scale :"),page,"label10");
  m_AScaleButton = new KColorButton (page);
  m_analogFontColorLabel = new TQLabel(i18n("Color of font :"),page,"label11");
  m_AFontButton = new KColorButton (page);

  m_digitalProcessingLabel = new TQLabel(i18n("Digital processing of pointers :"),page,"label12");
  m_digitalProcesingOfPointers = new KComboBox (page);


  setColorLayout->addWidget ( initAnalogLabel1, 0,0);
  setColorLayout->addWidget ( m_checkBoxCbac ,0,1);
  setColorLayout->addWidget ( m_analogBackgroundColorLabel, 1,0);
  setColorLayout->addWidget ( m_BGAButton ,1,1);
  setColorLayout->addWidget ( initAnalogLabel12, 2,0);
  setColorLayout->addWidget ( m_checkBoxCoac ,2,1);
  setColorLayout->addWidget ( m_analogPointerColorLabel, 3,0);
  setColorLayout->addWidget ( m_AFingerButton ,3,1);
  setColorLayout->addWidget ( m_analogOKColorLabel, 4,0);
  setColorLayout->addWidget ( m_AOKButton ,4,1);
  setColorLayout->addWidget ( m_analogWarningColorLabel, 5,0);
  setColorLayout->addWidget ( m_AWarnningButton ,5,1);
  setColorLayout->addWidget ( m_analogErrorColorLabel, 6,0);
  setColorLayout->addWidget ( m_AErrorButton ,6,1);
  setColorLayout->addWidget ( m_analogScaleColorLabel, 7,0);
  setColorLayout->addWidget ( m_AScaleButton ,7,1);
  setColorLayout->addWidget ( m_analogFontColorLabel, 8,0);
  setColorLayout->addWidget ( m_AFontButton ,8,1);
  setColorLayout->addWidget ( m_digitalProcessingLabel, 9,0);
  setColorLayout->addWidget ( m_digitalProcesingOfPointers, 9,1);


  m_checkBoxCbac->setChecked(m_settingData->customBAnalogColor);
  m_checkBoxCoac->setChecked(m_settingData->customOAnalogColor);
  m_BGAButton->setColor(m_settingData->aPanelBackgroundColor);
  m_BGAButton->setEnabled(m_settingData->customBAnalogColor);
  m_AFingerButton->setColor(m_settingData->analogFingerColor);
  m_AFingerButton->setEnabled(m_settingData->customOAnalogColor);
  m_AOKButton->setColor(m_settingData->analogOKColor);
  m_AOKButton->setEnabled(m_settingData->customOAnalogColor);
  m_AWarnningButton->setColor(m_settingData->analogWarnningColor);
  m_AWarnningButton->setEnabled(m_settingData->customOAnalogColor);
  m_AErrorButton->setColor(m_settingData->analogErrorColor);
  m_AErrorButton->setEnabled(m_settingData->customOAnalogColor);
  m_AScaleButton->setColor(m_settingData->analogScaleColor);
  m_AScaleButton->setEnabled(m_settingData->customOAnalogColor);
  m_AFontButton->setColor(m_settingData->analogFontColor);
  m_AFontButton->setEnabled(m_settingData->customOAnalogColor);
  m_analogBackgroundColorLabel->setEnabled(m_settingData->customBAnalogColor);
  m_analogPointerColorLabel->setEnabled(m_settingData->customOAnalogColor);
  m_analogOKColorLabel->setEnabled(m_settingData->customOAnalogColor);
  m_analogWarningColorLabel->setEnabled(m_settingData->customOAnalogColor);
  m_analogErrorColorLabel->setEnabled(m_settingData->customOAnalogColor);
  m_analogScaleColorLabel->setEnabled(m_settingData->customOAnalogColor);
  m_analogFontColorLabel->setEnabled(m_settingData->customOAnalogColor);


  m_digitalProcesingOfPointers->insertItem(i18n("Nothing processing"));
  m_digitalProcesingOfPointers->insertItem(i18n("Fast antialiasing"));
  m_digitalProcesingOfPointers->insertItem(i18n("Fine antialiasing"));
  m_digitalProcesingOfPointers->insertItem(i18n("Fast antialiasing and blur motion"));
  m_digitalProcesingOfPointers->insertItem(i18n("Fine antialiasing and blur motion"));

  m_digitalProcesingOfPointers->setCurrentItem(m_settingData->typeDigitalProcessing);


  connect (m_checkBoxCbac,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotUseCustomBAnalogColor(bool)));
  connect (m_checkBoxCoac,TQ_SIGNAL(toggled(bool)),this,TQ_SLOT(slotUseCustomOAnalogColor(bool)));
  }



#include "knutprefdlg.moc"
