/* This file is part of the KDE project
   Copyright (C) 2002 Ariya Hidayat <ariyahidayat@yahoo.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __AMIPROPARSER_H
#define __AMIPROPARSER_H

class TQString;
class TQStringList;
#include <tqvaluelist.h>
#include <tqcolor.h>

class AmiPro
{
  public:
    static const float LS_Single, LS_OneAndHalf, LS_Double;
};

class AmiProStyle;

class AmiProFormat
{
  public:
    int pos, len;
    bool bold, italic, underline;
    bool word_underline, double_underline;
    bool subscript, superscript, strikethrough;
    TQString fontFamily;
    float fontSize;
    TQColor fontColor;
    enum { Left, Right, Center, Justified } align;
    AmiProFormat();
    AmiProFormat( const AmiProFormat& );
    AmiProFormat& operator=( const AmiProFormat& );
    void assign( const AmiProFormat& );
    void applyStyle( const AmiProStyle& );
};

typedef TQValueList<AmiProFormat> AmiProFormatList;


class AmiProLayout
{
  public:
    TQString name;
    TQString fontFamily;
    float fontSize;
    TQColor fontColor;
    bool bold, italic, underline;
    bool word_underline, double_underline;
    bool subscript, superscript, strikethrough;
    TQt::AlignmentFlags align;
    float linespace;
    float spaceBefore, spaceAfter;
    AmiProLayout();
    AmiProLayout( const AmiProLayout& );
    AmiProLayout& operator=( const AmiProLayout& );
    void assign( const AmiProLayout& );
    void applyStyle( const AmiProStyle& );
};

class AmiProStyle
{
  public:
    TQString name;
    TQString fontFamily;
    float fontSize;
    TQColor fontColor;
    bool bold, italic, underline;
    bool word_underline, double_underline;
    bool subscript, superscript, strikethrough;
    TQt::AlignmentFlags align;
    float linespace;
    float spaceBefore, spaceAfter;
    AmiProStyle();
    AmiProStyle( const AmiProStyle& );
    AmiProStyle& operator=( const AmiProStyle& );
    void assign( const AmiProStyle& );
};

typedef TQValueList<AmiProStyle> AmiProStyleList;

class AmiProListener
{
  public: 
    AmiProListener();
    virtual ~AmiProListener();
    virtual bool doOpenDocument();
    virtual bool doCloseDocument();   
    virtual bool doDefineStyle( const AmiProStyle& style );
    virtual bool doParagraph( const TQString& text, AmiProFormatList formatList, 
      AmiProLayout& layout );
};

class AmiProParser
{

  public:
    AmiProParser();
    virtual ~AmiProParser();

    enum { OK, UnknownError, FileError, InvalidFormat } Error;

    bool process( const TQString& filename );
    int result(){ return m_result; }

    void setListener( AmiProListener * );

  private:

    int m_result;
    TQString m_text;
    AmiProFormat m_currentFormat;
    AmiProFormatList m_formatList;
    AmiProLayout m_layout;
    AmiProStyleList m_styleList;


    AmiProListener *m_listener;

    TQString m_currentSection;

    bool setResult( int );
    bool parseParagraph( const TQStringList& lines );
    bool parseStyle( const TQStringList& line );
    AmiProStyle findStyle( const TQString& name );

    bool handleTag( const TQString& tag );
    bool processOpenDocument();
    bool processCloseDocument();
    bool processParagraph( const TQString& text, AmiProFormatList formatList,
      AmiProLayout& layout );

};

#endif
