/* This file is part of the KDE project
   Copyright (C) 2003 Lucijan Busch <lucijan@gmx.at>
   Copyright (C) 2003-2004 Jaroslaw Staniek <js@iidea.pl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <sys/types.h>
#include <unistd.h>

#include <tqdom.h>
#include <tqdir.h>
#include <tqfile.h>
#include <tqregexp.h>

#include <tdeglobal.h>
#include <tdestandarddirs.h>
#include <kdebug.h>
#include <tdeio/netaccess.h>
#include <kurl.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

#include <kexidb/drivermanager.h>
#include "kexiprojectdata.h"


//! @internal
class KexiProjectDataPrivate
{
public:
	KexiProjectDataPrivate()
	 : userMode(false)
	 , readOnly(false)
	{}
	
	KexiDB::ConnectionData connData;
	TQDateTime lastOpened;
	bool userMode : 1;
	bool readOnly : 1;
};

//---------------------------------------

KexiProjectData::KexiProjectData()
 : TQObject(0, "KexiProjectData")
 , KexiDB::SchemaData()
 , formatVersion(0)
 , d( new KexiProjectDataPrivate() )
{
}

KexiProjectData::KexiProjectData( 
	const KexiDB::ConnectionData &cdata, const TQString& dbname, const TQString& caption )
 : TQObject(0, "KexiProjectData")
 , KexiDB::SchemaData()
 , formatVersion(0)
 , d( new KexiProjectDataPrivate() )
{
	d->connData = cdata;
	setDatabaseName(dbname);
	setCaption(caption);
}

KexiProjectData::KexiProjectData( const KexiProjectData& pdata )
 : TQObject(0, "KexiProjectData"), KexiDB::SchemaData()
 , d( 0 )
{
	*this = pdata;
	autoopenObjects = pdata.autoopenObjects;
/*
	d->connData = *pdata.connectionData();
	setDatabaseName(pdata.databaseName());
	setCaption(pdata.caption());*/
}

KexiProjectData::~KexiProjectData()
{
	delete d;
}

KexiProjectData& KexiProjectData::operator=(const KexiProjectData& pdata)
{
	delete d; //this is old
	static_cast<KexiDB::SchemaData&>(*this) = static_cast<const KexiDB::SchemaData&>(pdata);
	//deep copy
	d = new KexiProjectDataPrivate();
	*d = *pdata.d;
//	d->connData = *pdata.constConnectionData();
//	setDatabaseName(pdata.databaseName());
//	setCaption(pdata.caption());
//	setDescription(pdata.description());
	return *this;
}

KexiDB::ConnectionData* KexiProjectData::connectionData()
{
	return &d->connData;
}

const KexiDB::ConnectionData* KexiProjectData::constConnectionData() const
{
	return &d->connData;
}

TQString KexiProjectData::databaseName() const
{
	return KexiDB::SchemaData::name();
}

void KexiProjectData::setDatabaseName(const TQString& dbName)
{
	KexiDB::SchemaData::setName(dbName);
}

bool KexiProjectData::userMode() const
{
	return d->userMode;
}

TQDateTime KexiProjectData::lastOpened() const
{
	return d->lastOpened;
}

void KexiProjectData::setLastOpened(const TQDateTime& lastOpened)
{
	d->lastOpened=lastOpened;

}
TQString KexiProjectData::description() const
{
	return KexiDB::SchemaData::description();
}

void KexiProjectData::setDescription(const TQString& desc)
{
	return KexiDB::SchemaData::setDescription(desc);
}

TQString KexiProjectData::infoString(bool nobr) const
{
	if (constConnectionData()->fileName().isEmpty()) {
		//server-based
		return TQString(nobr ? "<nobr>" : "") + TQString("\"%1\"").arg(databaseName()) + (nobr ? "</nobr>" : "")
			+ (nobr ? " <nobr>" : " ") + i18n("database connection", "(connection %1)")
			.arg(constConnectionData()->serverInfoString()) + (nobr ? "</nobr>" : "");
	}
	//file-based
	return TQString(nobr ? "<nobr>" : "") 
		+ TQString("\"%1\"").arg(constConnectionData()->fileName()) + (nobr ? "</nobr>" : "");
}

void KexiProjectData::setReadOnly(bool set)
{
	d->readOnly = set;
}

bool KexiProjectData::isReadOnly() const
{
	return d->readOnly;
}

