#ifndef KEXIUSERACTIONMETHOD_H
#define KEXIUSERACTIONMETHOD_H

#include <tqvaluevector.h>
#include <tqstring.h>
#include <tqvariant.h>

typedef TQValueVector<int> ArgTypes;
typedef TQValueVector<TQString> ArgNames;

/*! describes a UserActionCommand */
class KEXICORE_EXPORT KexiUserActionMethod
{
	public:
		/*! constructs a UserActionCommand describtion */
		KexiUserActionMethod(int method, ArgTypes types, ArgNames names);

		/*! \return method id of this method */
		int method() { return m_method; }

		/*! \return argument type information of this method */
		ArgTypes types() { return m_types; }

		/*! \return i18n argument names of this method */
		ArgNames names() { return m_names; }



		/*! \return i18n method name for \a method */
		static TQString methodName(int method);

		/*! \return an i18n string for \a type */
		static TQString typeName(int type);

	private:
		int m_method;
		ArgTypes m_types;
		ArgNames m_names;
};

#endif

