/* This file is part of the KDE project
   Copyright (C) 2005 Dag Andersen <danders@get2net.dk>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation;
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KPTWBSDEFINITION_H
#define KPTWBSDEFINITION_H

#include <tqstring.h>
#include <tqmap.h>
#include <tqpair.h>
#include <tqvaluelist.h>

class TQStringList;

namespace KPlato
{

class Part;

class WBSDefinition {

public:
    WBSDefinition();
    ~WBSDefinition();

    class CodeDef {
        public:
            CodeDef() {}
            CodeDef(TQString c, TQString s) { code = c; separator = s; }
            ~CodeDef() {}
            void clear() { code = separator = TQString(); }
            bool isEmpty() { return code.isEmpty(); }
            TQString code;
            TQString separator;
    };
    
    void clear();
    
    /// Return wbs string.
    TQString wbs(uint index, int level);
    /// Return wbs code.
    TQString code(uint index, int level);
    /// Return wbs separator.
    TQString separator(int level);
    
    CodeDef &defaultDef() { return m_defaultDef; }
    void setDefaultDef(CodeDef def) { m_defaultDef = def; }
    
    bool isLevelsDefEnabled() const { return m_levelsEnabled; }
    bool level0Enabled();
    void setLevelsDefEnabled(bool on) { m_levelsEnabled = on; }
    void clearLevelsDef() { m_levelsDef.clear(); }
    const TQMap<int, CodeDef> &levelsDef() const { return m_levelsDef; }
    void setLevelsDef(TQMap<int, CodeDef> def);
    CodeDef levelsDef(int level) const;
    void setLevelsDef(int level, CodeDef def);
    void setLevelsDef(int level, TQString c, TQString s);
    
    TQStringList codeList();
    int defaultCodeIndex() const;
    bool setDefaultCode(uint index);
    TQString defaultSeparator() const { return m_defaultDef.separator; }
    void setDefaultSeparator(TQString s);

protected:
    TQString code(CodeDef &def, uint index);
    TQString toRoman(int n, bool upper = false);
    
private:
    CodeDef m_defaultDef;
    
    bool m_levelsEnabled;
    TQMap<int, CodeDef> m_levelsDef;

    TQValueList<TQPair<TQString, TQString> > m_codeLists;
};

} //namespace KPlato

#endif //WBSDEFINITION_H
