/***************************************************************************
                          item.h  -  description
                             -------------------
    begin                : Fri May 23 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef ITEM_H
#define ITEM_H

#include <kiconloader.h>
#include <twin.h>

#include <tqstring.h>
#include <tqpixmap.h>
#include <tqptrlist.h>

#include <vector>
#include <tqevent.h>
#include <tqnamespace.h>

const int MAX_LEN = 256;
const int SIZE_INC = 1;

class Item
{
  public:
    Item(const TQString& iconName, const TQString& cmd, const TQString& name, int minSize, int maxSize);
    Item(const TQString& fileName, int minSize, int maxSize);
    Item(const TQPixmap& iconBig, WId id, const TQString& name, int minSize, int maxSize, bool wi = false);
    ~Item();

    void setIcon(const TQPixmap& iconBig);

    TQPixmap* getIcon(int size);
    TQString getCommand();
    TQString getName();
    TQCString getClass();
    int getCount();
    int getIndex();
    int getMIndex();
    WId getId();
    KWin::WindowInfo info;
    void setId(WId newId);
    TQString getFilename();

    void setName(const TQString& newName);
    void setClass(const TQCString& newClass);
    void setCount(int newCount);
    void setIndex(int newIndex);
    void setMIndex(int newIndex);
    bool animed;
    bool isAnimed();
    void anim(bool param);
    TQPtrList<TQPixmap> icons;
    bool wIcon;

  private:
    TDEIconLoader* iLoader;

    int minSize;
    int maxSize;
    TQString command;
    TQString name;
    TQCString mClass;
    int mCount;
    int mIndex;
    int mMIndex;
    TQString iconName;
    TQString filename;
    WId id;
};

#endif // ITEM_H
