/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#ifndef _LOG_LINE_H_
#define _LOG_LINE_H_

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqdatetime.h>
#include <tqlistview.h>

#include <kurl.h>

#include "globals.h"

#include "logListItem.h"
#include "logLevel.h"

class LogListItem;

class ParentLogLine;
class ChildLogLine;


/**
 * @author Nicolas Ternisien
 */
class LogLine {
	
	public:
		LogLine(TQDate& date, TQTime& time, TQStringList& list, TQString& originalFile, LogLevel* level, int tpe);

		virtual ~LogLine();
		
		bool isOlderThan(LogLine& other);
		bool isNewerThan(LogLine& other);
		
		bool isOlderThan(TQDateTime& other);
		bool isNewerThan(TQDateTime& other);
		
		bool equals(LogLine& other);

		bool isSameTime(LogLine& other);
		
		bool operator<(LogLine& other);
		bool operator>(LogLine& other);
		//bool operator==(LogLine& other);
		
		LogLevel* getLogLevel();
		void setLogLevel(LogLevel* level);
		
		TQDateTime& getTime();
		TQStringList& getItemList();
		TQString& getOriginalFile();
		
		int getType();
		void setType(int t);
		
		void setRecent(bool recent);
		bool isRecent();
		
		
		bool itemExists();

		//Use this function carefully (don't delete the returned object for example)
		LogListItem* getLogListItem();

		virtual LogListItem* insertItem(TQListView* view);
		void removeItem(TQListView* view);

		void ensureItemVisible(TQListView* view);
		
		virtual bool isParentLogLine();
		virtual bool isChildLogLine();

	protected:

		TQDateTime time;
		
		TQStringList itemList;
		
		TQString originalFile;

		LogLevel* logLevel;
		
		int type;
		
		bool recent;
		
		LogListItem* item;
		

};

#endif
