/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef EVENTINFO_H
#define EVENTINFO_H

#include <tqpoint.h>

class ItemView;

class TQCanvasItem;
class TQEvent;
class TQMouseEvent;
class TQWheelEvent;

/**
Contains information from for a mouse event that occured on a canvas. Like a
TQMouseEvent / TQEvent / TQWheelEvent, but abstracted to the canvas coordinate
system, as well as holding lots of useful information.
@author David Saxton
*/
class EventInfo
{
public:
	EventInfo();
	EventInfo( ItemView *itemView, TQMouseEvent *e );
	EventInfo( ItemView *itemView, TQWheelEvent *e );
	EventInfo( ItemView *itemView, TQEvent *e );
	
	TQMouseEvent *mousePressEvent( int dx, int dy ) const;
	TQMouseEvent *mouseReleaseEvent( int dx, int dy ) const;
	TQMouseEvent *mouseDoubleClickEvent( int dx, int dy ) const;
	TQMouseEvent *mouseMoveEvent( int dx, int dy ) const;
	TQWheelEvent *wheelEvent( int dx, int dy ) const;
	
	TQPoint pos;
	TQPoint globalPos;
	TQCanvasItem *qcanvasItemClickedOn;
	int itemRtti;
	short scrollDelta;
	TQt::Orientation scrollOrientation;
	bool isRightClick:1;
	bool ctrlPressed:1;
	bool shiftPressed:1;
	bool altPressed:1;
	
protected:
	void reset();
};

#endif
