/***************************************************************************
 *   Copyright (C) 2003-2005 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef LIBRARYITEM_H
#define LIBRARYITEM_H

#include "item.h"

class TQStringList;

/**
This holds details of an item - id, name, category it is displayed in in its
respective item selector, icon, function pointers to creating the item, etc.
Normally each item will only pass one id, but some items have had their IDs
changed during the history of ktl, so passing a stringlist will take the first
ID as the "active" id, and the rest as IDs that will also be recognized, but
never displayed to the user.
@short Details of an Item
@author David Saxton
*/
class LibraryItem
{
	public:
		~LibraryItem();
	
		enum Type
		{
			lit_flowpart,
			lit_component,
			lit_mechanical,
			lit_drawpart,
			lit_subcircuit,
			lit_other
		};
		LibraryItem( TQStringList idList, const TQString &name, const TQString &category, TQPixmap icon, Type type, createItemPtr createItem );
		LibraryItem( TQStringList idList, const TQString &name, const TQString &category, const TQString &iconName, Type type, createItemPtr createItem );
		LibraryItem( TQStringList idList, const TQString &name, const TQString &category, Type type, createItemPtr createItem );
	
		TQString activeID() const;
		TQStringList allIDs() const { return m_idList; }
		TQString name() const { return m_name; }
		TQString category() const { return m_category; }
		TQPixmap iconFull() const { return m_icon_full; }
		TQPixmap icon16() const { return m_icon_16; }
		createItemPtr createItemFnPtr() const { return createItem; }
		int type() const { return m_type; }
	
	protected:
		void createIcon16();
	
	private:
		TQStringList m_idList;
		TQString m_name;
		TQString m_category;
		TQPixmap m_icon_full;
		TQPixmap m_icon_16;
		createItemPtr createItem;
		int m_type;
};
typedef TQValueList<LibraryItem*> LibraryItemList;

#endif
