/*
 * kxsldbg.cpp
 *
 * Copyright (C) 2001  <kurt@granroth.org>
 */
#include "kxsldbg.h"

#include <kkeydialog.h>
#include <tdeconfig.h>
#include <tdelocale.h>

#include <kedittoolbar.h>

#include <tdeaction.h>
#include <kstdaction.h>

#include <klibloader.h>
#include <tdemessagebox.h>
#include <kstatusbar.h>
#include <tdepopupmenu.h>
#include <tdemenubar.h>
#include <kiconloader.h>

KXsldbg::KXsldbg()
  : DCOPObject("KXsldbg"), KParts::MainWindow( 0L, "kxsldbg" )
{
    // set the shell's ui resource file
    setXMLFile("kxsldbg_shell.rc");

    // then, setup our actions
    setupActions();

    // and a status bar
    statusBar()->show();
    statusBar()->setSizePolicy(TQSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Preferred));

    // this routine will find and load our Part.  it finds the Part by
    // name which is a bad idea usually.. but it's alright in this
    // case since our Part is made for this Shell
    KLibFactory *factory = KLibLoader::self()->factory("libkxsldbgpart");
    if (factory)
    {
        // now that the Part is loaded, we cast it to a Part to get
        // our hands on it
        m_part = static_cast<KParts::ReadOnlyPart *>(factory->create(this,
                                "kxsldbg_part", "KParts::ReadOnlyPart" ));

        if (m_part)
        {
            // tell the KParts::MainWindow that this is indeed the main widget
            setCentralWidget(m_part->widget());

            // and integrate the part's GUI with the shell's
            createGUI(m_part);

            // connect up signals
            tdeApp->dcopClient()->attach();
            connectDCOPSignal(0, 0, "debuggerPositionChanged(TQString,int)", "newDebuggerPosition(TQString,int)", false );
            connectDCOPSignal(0, 0, "editorPositionChanged(TQString,int,int)", "newCursorPosition(TQString,int,int)", false );
            
            // Add xsldbg handbook to help menu
            TQMenuBar *mbar = menuBar();
            TDEPopupMenu *help_menu = dynamic_cast<TDEPopupMenu*>
                                      (menuBar()->findItem(mbar->idAt(mbar->count()-1))->popup());
            if (help_menu)
            {
                help_menu->insertItem(SmallIconSet("contents"), i18n("&XSLDbg Handbook"), this,
                                      TQ_SLOT(showXSLDbgHelp()), 0, -1, 1);
            }
        }
    }
    else
    {
        // if we couldn't find our Part, we exit since the Shell by
        // itself can't do anything useful
        KMessageBox::error(this, i18n("Could not find our part."));
        tdeApp->quit();
    }
}

KXsldbg::~KXsldbg()
{
    if (m_part)
	m_part->closeURL();

    delete m_part;
}

void KXsldbg::quit()
{
    closeURL();
    close();
}

bool KXsldbg::closeURL()
{
    if (m_part)
	m_part->closeURL();

    return true;
}

void KXsldbg::setupActions()
{
    TDEAction *act = KStdAction::quit(tdeApp, TQ_SLOT(quit()), actionCollection());
    connect(act, TQ_SIGNAL(activated()), this, TQ_SLOT(quit()));

    m_toolbarAction = KStdAction::showToolbar(this, TQ_SLOT(optionsShowToolbar()), actionCollection());
    m_statusbarAction = KStdAction::showStatusbar(this, TQ_SLOT(optionsShowStatusbar()), actionCollection());

    KStdAction::keyBindings(this, TQ_SLOT(optionsConfigureKeys()), actionCollection());
    KStdAction::configureToolbars(this, TQ_SLOT(optionsConfigureToolbars()), actionCollection());
}

void KXsldbg::saveProperties(TDEConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  anything you write here will be available
    // later when this app is restored
}

void KXsldbg::readProperties(TDEConfig* /*config*/)
{
    // the 'config' object points to the session managed
    // config file.  this function is automatically called whenever
    // the app is being restored.  read in here whatever you wrote
    // in 'saveProperties'
}


void KXsldbg::optionsShowToolbar()
{
    // this is all very cut and paste code for showing/hiding the
    // toolbar
    if (m_toolbarAction->isChecked())
        toolBar()->show();
    else
        toolBar()->hide();
}

void KXsldbg::optionsShowStatusbar()
{
    // this is all very cut and paste code for showing/hiding the
    // statusbar
    if (m_statusbarAction->isChecked())
        statusBar()->show();
    else
        statusBar()->hide();
}

void KXsldbg::optionsConfigureKeys()
{
    KKeyDialog::configure(actionCollection(), "kxsldbg_shell.rc");
}

void KXsldbg::optionsConfigureToolbars()
{
    saveMainWindowSettings(TDEGlobal::config(), "MainWindow");

    // use the standard toolbar editor
    KEditToolbar dlg(factory());
    connect(&dlg, TQ_SIGNAL(newToolbarConfig()),
            this, TQ_SLOT(applyNewToolbarConfig()));
    dlg.exec();
}

void KXsldbg::applyNewToolbarConfig()
{
    applyMainWindowSettings(TDEGlobal::config(), "MainWindow");
}


void KXsldbg::newCursorPosition(const TQString &file, int lineNumber, int columnNumber)
{
    statusBar()->clear();
    statusBar()->message( i18n("File: %1  Line: %2  Col: %3").arg(file).arg(lineNumber).arg(columnNumber));
}

void KXsldbg::newDebuggerPosition(const TQString &file, int lineNumber)
{
    // maybe do something extra here later
    newCursorPosition(file, lineNumber);
}

void KXsldbg::showXSLDbgHelp()
{
    tdeApp->invokeHelp(TQString(), "xsldbg");
}

#include "kxsldbg.moc"
