/* ============================================================
 * File   : imagecollectionshared.h
 * Authors: KIPI team developers (see AUTHORS files for details)
 *	    
 * Date   : 2004-02
 * Description :
 *
 * Copyright 2004 by the KIPI team
 * 
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * ============================================================ */
 
#ifndef KIPI_IMAGECOLLECTIONSHARED_H
#define KIPI_IMAGECOLLECTIONSHARED_H

// TQt Includes.

#include <tqstring.h>
#include <tqdatetime.h>

// KDE includes.

#include <kurl.h>

// Local includes.

#include "imagecollection.h"
#include "libkipi/libkipi_export.h"

namespace KIPI
{
    class LIBKIPI_EXPORT ImageCollectionShared
    {
    public:
        ImageCollectionShared();
        virtual ~ImageCollectionShared() {}
        virtual TQString name() = 0;
        virtual TQString comment();
        virtual TQString category();
        virtual TQDate date();
        virtual KURL::List images() = 0;
        virtual KURL path();
        virtual KURL uploadPath();
        virtual KURL uploadRoot();
        virtual TQString uploadRootName();
        virtual bool isDirectory();
        virtual bool operator==(ImageCollectionShared&);

    private:
        friend class ImageCollection;
        void addRef();
        void removeRef();
        int _count;
    };
}

#endif /* IMAGECOLLECTIONSHARED_H */

