from PyTQt.tqt import TQt, TQFrame, TQHBoxLayout, TQVBoxLayout, TQStringList, TQLabel, \
     TQ_SIGNAL, TQ_SLOT
from tdeui import KHistoryCombo, KTextEdit


iconName = 'history'
labelText = 'KHistoryCombo'
docParts = ('tdeui', 'KHistoryCombo')
helpText = ('An example of the KHistoryCombo widget.'
            '\n\n'
            'Completion is enabled via the setHistoryItems call; when the second '
            'parameter is True, matching items from the list appear as you type.'
            '\n\n'
            'The activated signal is connected to the addToHistory '
            'slot to automatically add new items.')


historyText = 'a quick brown fox jumps over the lazy dog'


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.help = KTextEdit(helpText, '', self)
        self.historyCombo = KHistoryCombo(self)

        self.historySelectionLabel = TQLabel('Selected value: ', self)
        self.historySelection = TQLabel('(none)', self)

        items = TQStringList()
        for item in historyText.split():
            items.append(item)
        self.historyCombo.setHistoryItems(items, True)

        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help, 3)
        layout.addStretch(1)
        selectionLayout = TQHBoxLayout(layout, 4)
        selectionLayout.addWidget(self.historySelectionLabel, 1)
        selectionLayout.addWidget(self.historySelection, 10, TQt.AlignLeft)
        layout.addWidget(self.historyCombo, 0)
        layout.addStretch(10)

        self.connect(self.historyCombo, TQ_SIGNAL('activated(const TQString& )'),
                     self.historyCombo, TQ_SLOT('addToHistory(const TQString&)'))
        self.connect(self.historyCombo, TQ_SIGNAL('cleared()'),
                     self.historyCleared)
        self.connect(self.historyCombo, TQ_SIGNAL('activated(const TQString &)'),
                     self.historySelection.setText)

    def historyCleared(self):
        print('History combo cleared.')
        
