/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef GLOBALDEFS_H
#define GLOBALDEFS_H

#include <tqcolor.h>
#include <tqapplication.h>

#define BOXLAYOUT_DEFAULT_MARGIN 11
#define BOXLAYOUT_DEFAULT_SPACING 6

#ifndef NO_STATIC_COLORS
static TQColor *backColor1 = 0;
static TQColor *backColor2 = 0;
static TQColor *selectedBack = 0;

static void init_colors()
{
    if ( backColor1 )
	return;

#if 0 // a calculated alternative for backColor1
    TQColorGroup myCg = tqApp->palette().active();
    int h1, s1, v1;
    int h2, s2, v2;
    myCg.color( TQColorGroup::Base ).hsv( &h1, &s1, &v1 );
    myCg.color( TQColorGroup::Background ).hsv( &h2, &s2, &v2 );
    TQColor c( h1, s1, ( v1 + v2 ) / 2, TQColor::Hsv );
#endif

    backColor1 = new TQColor(  250, 248, 235 );
    backColor2 = new TQColor( 255, 255, 255 );
    selectedBack = new TQColor( 230, 230, 230 );
}

#endif

#endif
