//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQWidget;

/**

 This class defines an interface to all file views. Its intent is
 to allow to switch the view of the files in the selector very easily.
 It defines some pure functions, that must be implemented to
 make a file view working.
 Since this class is not a widget, but it's meant to be added to other
 widgets, its most important function is widget. This should return
 a pointer to the implemented widget.
		@author Stephan Kulow <coolo@kde.org>

		@short A base class for views of the KDE file selector.

*/
public class KFileView implements QtSupport, KFileViewInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KFileView(Class dummy){}

	public static final int VIRTUAL_SET_DROP_OPTIONS = 1;

	public static final int Files = 1;
	public static final int Directories = 2;
	public static final int All = Files|Directories;

	/**
		 Various options for drag and drop support.
		 These values can be or'd together.

			<li>
			<code>AutoOpenDirs</code> Automatically open directory after hovering above it
			 for a short while while dragging.
			</li>
					@short    Various options for drag and drop support.
	*/
	public static final int AutoOpenDirs = 1;

	/**
		 inserts a list of items.
				@short    inserts a list of items.
	*/
	public native void addItemList(ArrayList list);
	/**
		 a pure function to get a TQWidget, that can be added to
		 other widgets. This function is needed to make it possible for
		 derived classes to derive from other widgets.
				@short    a pure virtual function to get a TQWidget, that can be added to  other widgets.
	*/
	public native TQWidget widget();
	/**
		 Sets <code>filename</code> the current item in the view, if available.
		     		@short    Sets <code>filename</code> the current item in the view, if available.
	*/
	public native void setCurrentItem(String filename);
	/**
		 Reimplement this to set <code>item</code> the current item in the view, e.g.
		 the item having focus.
		     		@short    Reimplement this to set <code>item</code> the current item in the view, e.
	*/
	public native void setCurrentItem(KFileItem item);
	/**
				@return the "current" KFileItem, e.g. where the cursor is.
 Returns 0L when there is no current item (e.g. in an empty view).
 Subclasses have to implement this.

		@short
	*/
	public native KFileItem currentFileItem();
	/**
		 Clears the view and all item lists.
		     		@short    Clears the view and all item lists.
	*/
	public native void clear();
	/**
		 does a repaint of the view.
			 The default implementation calls
		 <pre>
		 widget().repaint(f)
		 </pre>
				@short    does a repaint of the view.
	*/
	public native void updateView(boolean f);
	public native void updateView();
	public native void updateView(KFileItem arg1);
	/**
		 Removes an item from the list; has to be implemented by the view.
		 Call KFileView.removeItem( item ) after removing it.
		     		@short    Removes an item from the list; has to be implemented by the view.
	*/
	public native void removeItem(KFileItem item);
	/**
		 This hook is called when all items of the currently listed directory
		 are listed and inserted into the view, i.e. there won't come any new
		 items anymore.
		     		@short    This hook is called when all items of the currently listed directory  are listed and inserted into the view, i.
	*/
	public native void listingCompleted();
	/**
		 Returns the sorting order of the internal list. Newly added files
		 are added through this sorting.
		      		@short    Returns the sorting order of the internal list.
	*/
	public native int sorting();
	/**
		 Sets the sorting order of the view.
			 Default is TQDir.Name | TQDir.IgnoreCase | TQDir.DirsFirst
		 Override this in your subclass and sort accordingly (usually by
		 setting the sorting-key for every item and telling TQIconView
		 or TQListView to sort.
			 A view may choose to use a different sorting than TQDir.Name, Time
		 or Size. E.g. to sort by mimetype or any possible string. Set the
		 sorting to TQDir.Unsorted for that and do the rest internally.
				@short    Sets the sorting order of the view.
		@see #sortingKey
	*/
	public native void setSorting(int sort);
	/**
		 Tells whether the current items are in reversed order (shortcut to
		 sorting() & TQDir.Reversed).
		     		@short    Tells whether the current items are in reversed order (shortcut to  sorting() & TQDir.Reversed).
	*/
	public native boolean isReversed();
	public native void sortReversed();
	/**
				@return the number of dirs and files

		@short
	*/
	public native int count();
	/**
				@return the number of files.

		@short
	*/
	public native int numFiles();
	/**
				@return the number of directories

		@short
	*/
	public native int numDirs();
	public native void setSelectionMode(int sm);
	public native void setViewMode(int vm);
	public native int viewMode();
	/**
				@return the localized name of the view, which could be displayed
 somewhere, e.g. in a menu, where the user can choose between views.

		@short
		@see #setViewName
	*/
	public native String viewName();
	/**
		 Sets the name of the view, which could be displayed somewhere.
		 E.g. "Image Preview".
		     		@short    Sets the name of the view, which could be displayed somewhere.
	*/
	public native void setViewName(String name);
	public native void setParentView(KFileViewInterface parent);
	/**
		 The derived view must implement this function to add
		 the file in the widget.
			 Make sure to call this implementation, i.e.
		 KFileView.insertItem( i );
			     		@short    The derived view must implement this function to add  the file in the widget.
	*/
	public native void insertItem(KFileItem i);
	/**
		 pure function, that should be implemented to clear
		 the view. At this moment the list is already empty
				@short    pure virtual function, that should be implemented to clear  the view.
	*/
	public native void clearView();
	/**
		 pure function, that should be implemented to make item i
		 visible, i.e. by scrolling the view appropriately.
		     		@short    pure virtual function, that should be implemented to make item i  visible, i.
	*/
	public native void ensureItemVisible(KFileItem i);
	/**
		 Clears any selection, unhighlights everything. Must be implemented by
		 the view.
		     		@short    Clears any selection, unhighlights everything.
	*/
	public native void clearSelection();
	/**
		 Selects all items. You may want to override this, if you can implement
		 it more efficiently than calling setSelected() with every item.
		 This works only in Multiselection mode of course.
		     		@short    Selects all items.
	*/
	public native void selectAll();
	/**
		 Inverts the current selection, i.e. selects all items, that were up to
		 now not selected and deselects the other.
		     		@short    Inverts the current selection, i.
	*/
	public native void invertSelection();
	/**
		 Tells the view that it should highlight the item.
		 This function must be implemented by the view.
				@short    Tells the view that it should highlight the item.
	*/
	public native void setSelected(KFileItem arg1, boolean enable);
	/**
				@return whether the given item is currently selected.
 Must be implemented by the view.

		@short
	*/
	public native boolean isSelected(KFileItem arg1);
	/**
				@return all currently highlighted items.

		@short
	*/
	public native ArrayList selectedItems();
	/**
				@return all items currently available in the current sort-order

		@short
	*/
	public native ArrayList items();
	public native KFileItem firstFileItem();
	public native KFileItem nextItem(KFileItem arg1);
	public native KFileItem prevItem(KFileItem arg1);
	/**
		 This is a KFileDialog specific hack: we want to select directories with
		 single click, but not files. But as a generic class, we have to be able
		 to select files on single click as well.
			 This gives us the opportunity to do both.
			 Every view has to decide when to call select( item ) when a file was
		 single-clicked, based on onlyDoubleClickSelectsFiles().
		     		@short    This is a KFileDialog specific hack: we want to select directories with  single click, but not files.
	*/
	public native void setOnlyDoubleClickSelectsFiles(boolean enable);
	/**
				@return whether files (not directories) should only be select()ed by
 double-clicks.

		@short
		@see #setOnlyDoubleClickSelectsFiles
	*/
	public native boolean onlyDoubleClickSelectsFiles();
	/**
		 increases the number of dirs and files.
				@return true if the item fits the view mode

		@short    increases the number of dirs and files.
	*/
	public native boolean updateNumbers(KFileItem i);
	/**
				@return the view-specific action-collection. Every view should
 add its actions here (if it has any) to make them available to
 e.g. the KDirOperator's popup-menu.

		@short
	*/
	public native TDEActionCollection actionCollection();
	public native KFileViewSignaler signaler();
	public native void readConfig(TDEConfig arg1, String group);
	public native void readConfig(TDEConfig arg1);
	public native void writeConfig(TDEConfig arg1, String group);
	public native void writeConfig(TDEConfig arg1);
	/**
		 Specify DND options. See DropOptions for details.
		 All options are disabled by default.
				@short    Specify DND options.
	*/
	public native void setDropOptions(int options);
	/**
		 Returns the DND options in effect.
		 See DropOptions for details.
				@short    Returns the DND options in effect.
	*/
	public native int dropOptions();
	/**
		 This method calculates a String from the given parameters, that is
		 suitable for sorting with e.g. TQIconView or TQListView. Their
		 Item-classes usually have a setKey( String ) method or a virtual
		 method String key() that is used for sorting.
			@param value Any string that should be used as sort criterion
			@param isDir Tells whether the key is computed for an item representing
		              a directory (directories are usually sorted before files)
			@param sortSpec An ORed combination of TQDir.SortSpec flags.
		                 Currently, the values IgnoreCase, Reversed and
		                 DirsFirst are taken into account.
		     		@short    This method calculates a String from the given parameters, that is  suitable for sorting with e.
	*/
	public static native String sortingKey(String value, boolean isDir, int sortSpec);
	/**
		 An overloaded method that takes not a String, but a number as sort
		 criterion. You can use this for file-sizes or dates/times for example.
		 If you use a time_t, you need to cast that to TDEIO.filesize_t because
		 of ambiguity problems.
		     		@short    An overloaded method that takes not a String, but a number as sort  criterion.
	*/
	public static native String sortingKey(long value, boolean isDir, int sortSpec);
	/**
			 delay before auto opening a directory
		     		@short
	*/
	public static native int autoOpenDelay();
}
