//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQIODevice;
import org.trinitydesktop.qt.TQIODeviceInterface;

/**

 The default constructor is designed to provide much the same
 functionality as the most commonly used C-implementation, while
 the other three constructors are meant to further simplify the
 process of obtaining a digest by calculating the result in a
 single step.
 KMD5 is state-based, that means you can add new contents with
 update() as long as you didn't request the digest value yet.
 After the digest value was requested, the object is "finalized"
 and you have to call reset() to be able to do another calculation
 with it.  The reason for this behavior is that upon requesting
 the message digest KMD5 has to pad the received contents up to a
 64 byte boundary to calculate its value. After this operation it
 is not possible to resume consuming data.
 <b></b>sage:
 A common usage of this class:
 <pre>
 String test1;
 KMD5.Digest rawResult;
 test1 = "This is a simple test.";
 KMD5 context (test1);
 cout << "Hex Digest output: " << context.hexDigest().data() << endl;
 </pre>
 To cut down on the unnecessary overhead of creating multiple KMD5
 objects, you can simply invoke reset() to reuse the same object
 in making another calculation:
 <pre>
 context.reset ();
 context.update ("TWO");
 context.update ("THREE");
 cout << "Hex Digest output: " << context.hexDigest().data() << endl;
 </pre>
		@author Dirk Mueller <mueller@kde.org>, Dawit Alemayehu <adawit@kde.org>

		@short An adapted C++ implementation of RSA Data Securities MD5 algorithm.

*/
public class KMD5 implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KMD5(Class dummy){}

	public KMD5() {
		newKMD5();
	}
	private native void newKMD5();
	/**
		 Constructor that updates the digest for the given string.
			@param in C string or binary data
			@param len if negative, calculates the length by using
		             strlen on the first parameter, otherwise
		             it trusts the given length (does not stop on NUL byte).
		   		@short    Constructor that updates the digest for the given string.
	*/
	public KMD5(String in, int len) {
		newKMD5(in,len);
	}
	private native void newKMD5(String in, int len);
	public KMD5(String in) {
		newKMD5(in);
	}
	private native void newKMD5(String in);
	/**
		 @overload
			 Same as above except it accepts a byte[] as its argument.
		   		@short    @overload
	*/
	public KMD5(byte[] a) {
		newKMD5(a);
	}
	private native void newKMD5(byte[] a);
	/**
		 Updates the message to be digested. Be sure to add all data
		 before you read the digest. After reading the digest, you
		 can <b>not</b> add more data!
			@param in message to be added to digest
			@param len the length of the given message.
		   		@short    Updates the message to be digested.
	*/
	public native void update(String in, int len);
	public native void update(String in);
	/**
		 @overload
		   		@short    @overload
	*/
	public native void update(short in, int len);
	public native void update(short in);
	/**
		 @overload
			@param in message to be added to the digest (byte[]).
		   		@short    @overload
	*/
	public native void update(byte[] in);
	/**
		 @overload
			 reads the data from an I/O device, i.e. from a file (TQFile).
			 NOTE that the file must be open for reading.
			@param file a pointer to FILE as returned by calls like f{d,re}open
				@return false if an error occurred during reading.

		@short    @overload
	*/
	public native boolean update(TQIODevice file);
	/**
		 Calling this function will reset the calculated message digest.
		 Use this method to perform another message digest calculation
		 without recreating the KMD5 object.
		   		@short    Calling this function will reset the calculated message digest.
	*/
	public native void reset();
	/**
				@return the raw representation of the digest

		@short
	*/
	// const KMD5::Digest& rawDigest(); >>>> NOT CONVERTED
	/**
		 Fills the given array with the binary representation of the
		 message digest.
			 Use this method if you do not want to worry about making
		 copy of the digest once you obtain it.
			@param bin an array of 16 characters ( char[16] )
		   		@short    Fills the given array with the binary representation of the  message digest.
	*/
	// void rawDigest(KMD5::Digest& arg1); >>>> NOT CONVERTED
	/**
		 Returns the value of the calculated message digest in
		 a hexadecimal representation.
		   		@short    Returns the value of the calculated message digest in  a hexadecimal representation.
	*/
	public native String hexDigest();
	/**
		 @overload
		   		@short    @overload
	*/
	public native void hexDigest(StringBuffer arg1);
	/**
		 Returns the value of the calculated message digest in
		 a base64-encoded representation.
		   		@short    Returns the value of the calculated message digest in  a base64-encoded representation.
	*/
	public native String base64Digest();
	/**
		 returns true if the calculated digest for the given
		 message matches the given one.
		   		@short    returns true if the calculated digest for the given  message matches the given one.
	*/
	// bool verify(const KMD5::Digest& arg1); >>>> NOT CONVERTED
	/**
		 @overload
		   		@short    @overload
	*/
	public native boolean verify(String arg1);
	/**
		 finalizes the digest
		   		@short    finalizes the digest
	*/
	protected native void finalizeDigest();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
