//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;

/**

 A basic message object used for exchanging filtering
 information between the filter plugins and the application
 requesting the filtering service.
 Use this object if you require a more detailed information
 about the URI you want to filter. Any application can create
 an instance of this class and send it to KURIFilter to
 have the plugins fill out all possible information about the
 URI.
 <b></b>xample
 <pre>
   String text = "kde.org";
   KURIFilterData d = text;
   boolean filtered = KURIFilter.self().filter( d );
   cout << "URL: " << text.latin1() << endl
        << "Filtered URL: " << d.uri().url().latin1() << endl
        << "URI Type: " << d.uriType() << endl
        << "Was Filtered: " << filtered << endl;
 </pre>
 The above code should yield the following output:
 <pre>
   URI: kde.org
   Filtered URI: http://kde.org
   URI Type: 0            <== means NET_PROTOCOL
   Was Filtered: 1        <== means the URL was successfully filtered
 </pre>
		@author Dawit Alemayehu <adawit at kde.org>

		@short A message object for exchanging filtering URI info.

*/
public class KURIFilterData implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KURIFilterData(Class dummy){}

	/**
		 Describes the type of the URI that was filtered.
		 Here is a brief description of the types:

			<li>
			NET_PROTOCOL - Any network protocol: http, ftp, nttp, pop3, etc...
			</li>

			<li>
			LOCAL_FILE   - A local file whose executable flag is not set
			</li>

			<li>
			LOCAL_DIR    - A local directory
			</li>

			<li>
			EXECUTABLE   - A local file whose executable flag is set
			</li>

			<li>
			HELP         - A man or info page
			</li>

			<li>
			SHELL        - A shell executable (ex: echo "Test..." >> ~/testfile)
			</li>

			<li>
			BLOCKED      - A URI that should be blocked/filtered (ex: ad filtering)
			</li>

			<li>
			ERROR        - An incorrect URI (ex: "~johndoe" when user johndoe
			                    does not exist in that system )
			</li>

			<li>
			UNKNOWN      - A URI that is not identified. Default value when
			                    a KURIFilterData is first created.

			</li>		@short    Describes the type of the URI that was filtered.
	*/
	public static final int NET_PROTOCOL = 0;
	public static final int LOCAL_FILE = 1;
	public static final int LOCAL_DIR = 2;
	public static final int EXECUTABLE = 3;
	public static final int HELP = 4;
	public static final int SHELL = 5;
	public static final int BLOCKED = 6;
	public static final int ERROR = 7;
	public static final int UNKNOWN = 8;

	/**
		 Default constructor.
			 Creates a URIFilterData object.
		     		@short    Default constructor.
	*/
	public KURIFilterData() {
		newKURIFilterData();
	}
	private native void newKURIFilterData();
	/**
		 Creates a URIFilterData object from the given URL.
			@param url is the URL to be filtered.
		     		@short    Creates a URIFilterData object from the given URL.
	*/
	public KURIFilterData(KURL url) {
		newKURIFilterData(url);
	}
	private native void newKURIFilterData(KURL url);
	/**
		 Creates a URIFilterData object from the given string.
			@param url is the string to be filtered.
		     		@short    Creates a URIFilterData object from the given string.
	*/
	public KURIFilterData(String url) {
		newKURIFilterData(url);
	}
	private native void newKURIFilterData(String url);
	/**
		 Copy constructor.
			 Creates a URIFilterData object from another
		 URI filter data object.
			@param data the uri filter data to be copied.
		     		@short    Copy constructor.
	*/
	public KURIFilterData(KURIFilterData data) {
		newKURIFilterData(data);
	}
	private native void newKURIFilterData(KURIFilterData data);
	/**
		 Returns the filtered or the original URL.
			 This function returns the filtered url if one
		 of the plugins successfully filtered the original
		 URL.  Otherwise, it returns the original URL.
		 See hasBeenFiltered() and
				@return the filtered or original url.

		@short    Returns the filtered or the original URL.
	*/
	public native KURL uri();
	/**
		 Returns an error message.
			 This functions returns the error message set
		 by the plugin whenever the uri type is set to
		 KURIFilterData.ERROR.  Otherwise, it returns
		 a null.
				@return the error message or a NULL when there is none.

		@short    Returns an error message.
	*/
	public native String errorMsg();
	/**
		 Returns the URI type.
			 This method always returns KURIFilterData.UNKNOWN
		 if the given URL was not filtered.
				@return the type of the URI

		@short    Returns the URI type.
	*/
	public native int uriType();
	/**
		 Sets the URL to be filtered.
			 Use this function to set the string to be
		 filtered when you construct an empty filter
		 object.
			@param url the string to be filtered.
		     		@short    Sets the URL to be filtered.
	*/
	public native void setData(String url);
	/**
		 Same as above except the argument is a URL.
			 Use this function to set the string to be
		 filtered when you construct an empty filter
		 object.
			@param url the URL to be filtered.
		     		@short    Same as above except the argument is a URL.
	*/
	public native void setData(KURL url);
	/**
		 Sets the absolute path to be used whenever the supplied
		 data is a relative local URL.
			 NOTE: This function should only be used for local resources,
		 i.e. the "file:/" protocol. It is useful for specifying the
		 absolute path in cases where the actual URL might be relative.
		 meta object.  If deriving the path from a KURL, make sure you
		 set the argument for this function to the result of calling
		 path () instead of url ().
			@param abs_path the abolute path to the local resource.
				@return true if absolute path is successfully set. Otherwise, false.

		@short    Sets the absolute path to be used whenever the supplied  data is a relative local URL.
	*/
	public native boolean setAbsolutePath(String abs_path);
	/**
		 Returns the absolute path if one has already been set.
				@return the absolute path, or null

		@short    Returns the absolute path if one has already been set.
		@see #hasAbsolutePath
	*/
	public native String absolutePath();
	/**
		 Checks whether the supplied data had an absolute path.
				@return true if the supplied data has an absolute path

		@short    Checks whether the supplied data had an absolute path.
		@see #absolutePath
	*/
	public native boolean hasAbsolutePath();
	/**
		 Returns the command line options and arguments for a
		 local resource when present.
				@return options and arguments when present, otherwise null

		@short    Returns the command line options and arguments for a  local resource when present.
	*/
	public native String argsAndOptions();
	/**
		 Checks whether the current data is a local resource with
		 command line options and arguments.
				@return true if the current data has command line options and arguments

		@short    Checks whether the current data is a local resource with  command line options and arguments.
	*/
	public native boolean hasArgsAndOptions();
	/**
		 Returns the name of the icon that matches
		 the current filtered URL.
			 NOTE that this function will return a NULL
		 string by default and when no associated icon
		 is found.
				@return the name of the icon associated with the resource,
         or null if not found

		@short    Returns the name of the icon that matches  the current filtered URL.
	*/
	public native String iconName();
	/**
		 Check whether the provided uri is executable or not.
			 Setting this to false ensures that typing the name of
		 an executable does not start that application. This is
		 useful in the location bar of a browser. The default
		 value is true.
				@short    Check whether the provided uri is executable or not.
	*/
	public native void setCheckForExecutables(boolean check);
	/**
				@return true if the filters should attempt to check whether the
 supplied uri is an executable. False otherwise.

		@short
	*/
	public native boolean checkForExecutables();
	/**
				@return the string as typed by the user, before any URL processing is done

		@short
	*/
	public native String typedString();
	/**
		 Initializes the KURIFilterData on construction.
			@param url the URL to initialize the object with
		     		@short    Initializes the KURIFilterData on construction.
	*/
	protected native void init(KURL url);
	/**
		 Initializes the KURIFilterData on construction.
			@param url the URL to initialize the object with
		     		@short    Initializes the KURIFilterData on construction.
	*/
	protected native void init(String url);
	protected native void init();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
