/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <tdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef TDEPRINTCHECK_H
#define TDEPRINTCHECK_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tdeconfig.h>
#include <kurl.h>

class TDEPRINT_EXPORT KdeprintChecker
{
public:
	static bool check(TDEConfig *conf, const TQString& group = TQString::null);
	static bool check(const TQStringList& uris);

private:
	static bool checkURL(const KURL&);
	static bool checkConfig(const KURL&);
	static bool checkExec(const KURL&);
	static bool checkService(const KURL&);
};

#endif
