/*
 * This is a simple tdeioslave to handle mbox-files.
 * Copyright (C) 2004 Mart Kelder (mart.kde@hccnet.nl)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "mbox.h"

#include "readmbox.h"
#include "stat.h"
#include "urlinfo.h"

#include <tqstring.h>
#include <tqcstring.h>

#include <kdebug.h>
#include <tdelocale.h>
#include <tdeinstance.h>
#include <tdeglobal.h>
#include <kurl.h>
#include <tdeio/global.h>

#include <stdlib.h>

#include <tdemacros.h>

#include "mbox.h"

extern "C" { TDE_EXPORT int kdemain(int argc, char* argv[]); }

int kdemain( int argc, char * argv[] )
{
	TDELocale::setMainCatalogue("tdelibs");
	TDEInstance instance("tdeio_mbox");
	(void) TDEGlobal::locale();

	if (argc != 4) {
		fprintf(stderr, "Usage: tdeio_mbox protocol "
	        	        "domain-socket1 domain-socket2\n");
		exit(-1);
	}

	MBoxProtocol slave(argv[2], argv[3]);
	slave.dispatchLoop();
	
	return 0;
}

MBoxProtocol::MBoxProtocol( const TQCString& arg1, const TQCString& arg2 )
	: TDEIO::SlaveBase( "mbox2", arg1, arg2 ),
	m_errorState( true )
{
	
}

MBoxProtocol::~MBoxProtocol()
{
}

void MBoxProtocol::get( const KURL& url )
{
	m_errorState = false;
	
	UrlInfo info( url, UrlInfo::message );
	TQString line;
	TQByteArray ba_line;

	if( info.type() == UrlInfo::invalid && !m_errorState )
	{
		error( TDEIO::ERR_DOES_NOT_EXIST, info.url() );
		return;
	}
	
	ReadMBox mbox( &info, this );

	while( !mbox.atEnd() && !m_errorState)
	{
		line = mbox.currentLine();
		line += '\n';
		ba_line = TQCString( line.utf8() );
		ba_line.truncate( ba_line.size() - 1 ); //Removing training '\0'
		data( ba_line );
		mbox.nextLine();
	};
	
	if( !m_errorState )
	{
		data( TQByteArray() );
		finished();
	}
}

void MBoxProtocol::listDir( const KURL& url )
{
	m_errorState = false;
	
	TDEIO::UDSEntry entry;
	UrlInfo info( url, UrlInfo::directory );
	ReadMBox mbox( &info, this, hasMetaData( "onlynew" ), hasMetaData( "savetime" ) );

	if( m_errorState )
		return;
	
	if( info.type() != UrlInfo::directory )
	{
		error( TDEIO::ERR_DOES_NOT_EXIST, info.url() );
		return;
	}
	
	while( !mbox.atEnd() && !m_errorState )
	{
		entry = Stat::stat( mbox, info );
		if( mbox.inListing() )
			listEntry( entry, false );
	}

	listEntry( TDEIO::UDSEntry(), true );
	finished();
}

void MBoxProtocol::stat( const KURL& url )
{
	UrlInfo info( url );
	if( info.type() == UrlInfo::invalid )
	{
		error( TDEIO::ERR_DOES_NOT_EXIST, url.path() );
		return;
	} else
	{
		statEntry( Stat::stat( info ) );
	}
	finished();
}

void MBoxProtocol::mimetype( const KURL& url )
{	
	m_errorState = false;
	
	UrlInfo info( url );

	if( m_errorState )
		return;
	
	if( info.type() == UrlInfo::invalid )
		error( TDEIO::ERR_DOES_NOT_EXIST, i18n( "Invalid URL" ) );
	else
		mimeType( info.mimetype() );
	finished();
}

void MBoxProtocol::emitError( int errno, const TQString& arg )
{
	m_errorState = true;
	error( errno, arg );
}

