/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "kde-features.h"
#include "kde-features_parser.h"

#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kdebug.h>

#include <tqfile.h>
#include <tqtextstream.h>

#include <iostream>

static const TDECmdLineOptions options[] =
{
  { "+featurelist", "Name of featurelist XML file", 0 },
  TDECmdLineLastOption
};

void displayFeature( Feature *f )
{
  std::cout << "FEATURE: " << f->summary().local8Bit() << std::endl;
  Responsible::List r = f->responsibleList();
  Responsible::List::ConstIterator it;
  for( it = r.begin(); it != r.end(); ++it ) {
    std::cout << "  RESPONSIBLE: " << (*it)->name().local8Bit() << " ("
              << (*it)->email().local8Bit() << ")" << std::endl;
  }
  std::cout << "  TARGET: " << f->target().local8Bit() << std::endl;
  std::cout << "  STATUS: " << f->status().local8Bit() << std::endl;
}

void displayCategory( const TQValueList<Category *> categories )
{
  Category::List::ConstIterator it;
  for( it = categories.begin(); it != categories.end(); ++it ) {
    std::cout << "CATEGORY: " << (*it)->name().local8Bit() << std::endl;
    
    Feature::List features = (*it)->featureList();
    Feature::List::ConstIterator it2;
    for( it2 = features.begin(); it2 != features.end(); ++it2 ) {
      displayFeature( *it2 );
    }
  
    displayCategory( (*it)->categoryList() );
  }
}

int main( int argc, char **argv )
{
  TDEAboutData aboutData( "dumpfeaturelist", "Dump XML feature list to stdout",
                        "0.1" );
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app( false, false );

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if ( args->count() != 1 ) {
    args->usage( "Wrong number of arguments." );
  }

  TQString filename = TQFile::decodeName( args->arg( 0 ) );

  FeaturesParser parser;

  Features *features = parser.parseFile( filename );

  if ( !features ) {
    kdError() << "Parse error" << endl;
  } else {
    TQValueList<Category *> categories = features->categoryList();
    displayCategory( categories );

    TQString out = filename + ".out";
    if ( !features->writeFile( out ) ) {
      kdError() << "Write error" << endl;
    }
  }
}
