/***************************************************************************
                          stationselection_interfaces.h  -  description
                             -------------------
    begin                : Son Aug 3 2003
    copyright            : (C) 2003 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_STATIONSELECTION_INTERFACES_H
#define KRADIO_STATIONSELECTION_INTERFACES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "interfaces.h"

class TQStringList;

INTERFACE(IStationSelection, IStationSelectionClient)
{
public :
    IF_CON_DESTRUCTOR(IStationSelection, -1)

RECEIVERS:
    IF_RECEIVER(    setStationSelection(const TQStringList &sl)              )

SENDERS:
    IF_SENDER  (    notifyStationSelectionChanged(const TQStringList &sl)    )

ANSWERS:
    IF_ANSWER  (    const TQStringList & getStationSelection () const        )

};


INTERFACE(IStationSelectionClient, IStationSelection)
{
public :
    IF_CON_DESTRUCTOR(IStationSelectionClient, 1)

SENDERS:
    IF_SENDER  (    sendStationSelection(const TQStringList &sl)             )

RECEIVERS:
    IF_RECEIVER(    noticeStationSelectionChanged(const TQStringList &sl)    )

QUERIES:
    IF_QUERY   (    const TQStringList & queryStationSelection ()            )


RECEIVERS:
    virtual void noticeConnectedI    (cmplInterface *, bool /*pointer_valid*/);
    virtual void noticeDisconnectedI (cmplInterface *, bool /*pointer_valid*/);
};


#endif
