#ifndef BUGCACHE_H
#define BUGCACHE_H

class TDESimpleConfig;

#include "package.h"
#include "bug.h"
#include "bugdetails.h"

class BugCache
{
    public:
        BugCache( const TQString &id );
        ~BugCache();

        void savePackageList( const Package::List &pkgs );
        Package::List loadPackageList();
        void invalidatePackageList();

        void saveBugList( const Package &pkg, const TQString &component, const Bug::List & );
        Bug::List loadBugList( const Package &pkg, const TQString &component, bool disconnected );
        void invalidateBugList( const Package &pkg, const TQString &component );

        void saveBugDetails( const Bug &bug, const BugDetails & );
        BugDetails loadBugDetails( const Bug &bug );
        void invalidateBugDetails( const Bug &bug );
        bool hasBugDetails( const Bug& bug ) const;

        void clear();

    private:
        void init();
    
        void writePerson( TDESimpleConfig *file, const TQString &key,
                          const Person &p );
        struct Person readPerson (TDESimpleConfig *file, const TQString &key );

        TQString mId;

        TDESimpleConfig *m_cachePackages;
        TDESimpleConfig *m_cacheBugs;

        TQString mCachePackagesFileName;
        TQString mCacheBugsFileName;
};

#endif
