

/* This file is part of the KDE project
   Copyright (C) 2005 Ian Reinhart Geiser <geiseri@kde.org>
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "kdevprojectiface.h"
#include "kdevproject.h"
#include "domutil.h"

KDevProjectIface::KDevProjectIface(KDevProject *prj)
  : TQObject(prj), DCOPObject("KDevProject"), m_prj(prj)
{
}


KDevProjectIface::~KDevProjectIface()
{
}

void KDevProjectIface::openProject( const TQString & dirName, const TQString & projectName )
{
  m_prj->openProject(dirName,projectName);
}

void KDevProjectIface::closeProject( )
{
  m_prj->closeProject();
}

uint KDevProjectIface::options( ) const
{
  return (uint)m_prj->options();
}

TQString KDevProjectIface::projectDirectory( ) const
{
  return m_prj->projectDirectory();
}

TQString KDevProjectIface::projectName( ) const
{
  return m_prj->projectName();
}

TQString KDevProjectIface::mainProgram() const
{
  return m_prj->mainProgram();
}

TQString KDevProjectIface::runDirectory( ) const
{
  return m_prj->runDirectory();
}

TQString KDevProjectIface::activeDirectory( ) const
{
  return m_prj->activeDirectory();
}

TQString KDevProjectIface::buildDirectory( ) const
{
  return m_prj->buildDirectory();
}

TQStringList KDevProjectIface::allFiles( ) const
{
  return m_prj->allFiles();
}

TQStringList KDevProjectIface::distFiles( ) const
{
  return m_prj->distFiles();
}

void KDevProjectIface::addFiles( const TQStringList & fileList )
{
  m_prj->addFiles(fileList);
}

void KDevProjectIface::addFile( const TQString & fileName )
{
  m_prj->addFile(fileName);
}

void KDevProjectIface::removeFiles( const TQStringList & fileList )
{
  m_prj->removeFiles(fileList);
}

void KDevProjectIface::removeFile( const TQString & fileName )
{
  m_prj->removeFile(fileName);
}

void KDevProjectIface::changedFiles( const TQStringList & fileList )
{
  m_prj->changedFiles(fileList);
}

void KDevProjectIface::changedFile( const TQString & fileName )
{
  m_prj->changedFile(fileName);
}

bool KDevProjectIface::isProjectFile( const TQString & absFileName )
{
  return m_prj->isProjectFile(absFileName);
}

TQString KDevProjectIface::relativeProjectFile( const TQString & absFileName )
{
  return m_prj->relativeProjectFile(absFileName);
}

TQStringList KDevProjectIface::symlinkProjectFiles( )
{
  return m_prj->symlinkProjectFiles();
}

TQString KDevProjectIface::readEntry( const TQString & path, const TQString & defaultEntry )
{
  return DomUtil::readEntry( *m_prj->projectDom(), path, defaultEntry);
}

int KDevProjectIface::readIntEntry( const TQString & path, int defaultEntry )
{
  return DomUtil::readIntEntry(*m_prj->projectDom(), path,defaultEntry);
}

bool KDevProjectIface::readBoolEntry( const TQString & path, bool defaultEntry )
{
  return DomUtil::readBoolEntry(*m_prj->projectDom(), path, defaultEntry);
}

TQStringList KDevProjectIface::readListEntry( const TQString & path, const TQString & tag )
{
  return DomUtil::readListEntry(*m_prj->projectDom(), path, tag);
}

TQMap< TQString, TQString > KDevProjectIface::readMapEntry( const TQString & path )
{
  return DomUtil::readMapEntry(*m_prj->projectDom(), path);
}

void KDevProjectIface::writeEntry( const TQString & path, const TQString & value )
{
  DomUtil::writeEntry(*m_prj->projectDom(), path, value);
}

void KDevProjectIface::writeIntEntry( const TQString & path, int value )
{
  DomUtil::writeIntEntry(*m_prj->projectDom(), path, value);
}

void KDevProjectIface::writeBoolEntry( const TQString & path, bool value )
{
  DomUtil::writeBoolEntry(*m_prj->projectDom(), path, value);
}

void KDevProjectIface::writeListEntry( const TQString & path, const TQString & tag, const TQStringList & value )
{
  DomUtil::writeListEntry(*m_prj->projectDom(), path, tag, value);
}

void KDevProjectIface::writeMapEntry( const TQString & path, const TQMap< TQString, TQString > & map )
{
  DomUtil::writeMapEntry(*m_prj->projectDom(), path, map);
}

#include "kdevprojectiface.moc"
