/***************************************************************************
                          imagemap.h  -  description
                             -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEMAP_H
#define IMAGEMAP_H

#include <tqscrollview.h>
#include <tqimage.h>
#include <tqpoint.h>
#include <tqrect.h>

#include "tdeversion.h"

/**
  *@author Jan Schfer
  */
class KImageMapEditor;
class Area;

class ImageMap : public TQScrollView  {
public:
	enum DrawAction { None, DrawCircle, DrawRectangle, DrawPolygon, MoveSelectionPoint, MoveArea };
private:
	TQRect imageRect;
	TQPoint drawStart;
	TQPoint drawCurrent;
	TQPoint drawEnd;
	bool eraseOldArea;
	Area *oldArea;
	// Holds the original image
	TQImage image;
	// Holds the zoomed image for efficiency reasons
	TQPixmap zoomedImage;
	Area *currentArea;
	DrawAction currentAction;
	TQRect *currentSelectionPoint;
	KImageMapEditor *imageMapEditor;
	double _zoom;
public:
	ImageMap(TQWidget *parent,KImageMapEditor* _imageMapEditor);
	~ImageMap();
	void setZoom(double z);
	void setPicture(const TQImage &_image);
	void repaintArea(const Area & a);
	TQImage picture() const;
	TQPoint translateFromZoom(const TQPoint & p) const;
	TQPoint translateToZoom(const TQPoint & p) const;
	TQRect translateToZoom(const TQRect & p) const;
protected:
	virtual void contentsMousePressEvent(TQMouseEvent* e);
	virtual void contentsMouseDoubleClickEvent(TQMouseEvent* e);
	virtual void contentsMouseReleaseEvent(TQMouseEvent *e);
	virtual void contentsMouseMoveEvent(TQMouseEvent *e);
	virtual void resizeEvent(TQResizeEvent* e);
	virtual void drawContents(TQPainter* p,int clipx,int clipy,int clipw,int cliph);
};

inline TQImage ImageMap::picture() const {
	return image;
}


#endif
