/***************************************************************************
    copyright            : (C) 2004-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_DCOPINTERFACE_H
#define TELLICO_DCOPINTERFACE_H

#include "../translators/translators.h"

#include <dcopobject.h>
#include <kurl.h>

#include <tqstringlist.h> // used in generated dcopinterface_skel.cpp

namespace Tellico {

class ApplicationInterface : public DCOPObject {
K_DCOP
k_dcop:
  bool importTellico(const TQString& file, const TQString& action)
    { return importFile(Import::TellicoXML, KURL::fromPathOrURL(file), actionType(action)); }
  bool importBibtex(const TQString& file, const TQString& action)
    { return importFile(Import::Bibtex, KURL::fromPathOrURL(file), actionType(action)); }
  bool importMODS(const TQString& file, const TQString& action)
    { return importFile(Import::MODS, KURL::fromPathOrURL(file), actionType(action)); }
  bool importRIS(const TQString& file, const TQString& action)
    { return importFile(Import::RIS, KURL::fromPathOrURL(file), actionType(action)); }

  bool exportXML(const TQString& file)
    { return exportCollection(Export::TellicoXML, KURL::fromPathOrURL(file)); }
  bool exportZip(const TQString& file)
    { return exportCollection(Export::TellicoZip, KURL::fromPathOrURL(file)); }
  bool exportBibtex(const TQString& file)
    { return exportCollection(Export::Bibtex, KURL::fromPathOrURL(file)); }
  bool exportHTML(const TQString& file)
    { return exportCollection(Export::HTML, KURL::fromPathOrURL(file)); }
  bool exportCSV(const TQString& file)
    { return exportCollection(Export::CSV, KURL::fromPathOrURL(file)); }
  bool exportPilotDB(const TQString& file)
    { return exportCollection(Export::PilotDB, KURL::fromPathOrURL(file)); }

  TQValueList<long> selectedEntries() const;
  TQValueList<long> filteredEntries() const;

  virtual void openFile(const TQString& file) = 0;
  virtual void setFilter(const TQString& text) = 0;
  virtual bool showEntry(long id) = 0;

protected:
  ApplicationInterface() : DCOPObject("tellico") {}
  virtual bool importFile(Import::Format format, const KURL& url, Import::Action action) = 0;
  virtual bool exportCollection(Export::Format format, const KURL& url) = 0;

private:
  Import::Action actionType(const TQString& actionName);
};

class CollectionInterface : public DCOPObject {
K_DCOP
k_dcop:
  long addEntry();
  bool removeEntry(long entryID);

  TQStringList values(const TQString& fieldName) const;
  TQStringList values(long entryID, const TQString& fieldName) const;
  TQStringList bibtexKeys() const;
  TQString bibtexKey(long entryID) const;

  bool setFieldValue(long entryID, const TQString& fieldName, const TQString& value);
  bool addFieldValue(long entryID, const TQString& fieldName, const TQString& value);

  friend class MainWindow;

protected:
  CollectionInterface() : DCOPObject("collection") {}
};

} // end namespace
#endif
