#include <tqiconview.h>
#include <tqdragobject.h>
#include <tqlayout.h>
#include <tqmultilineedit.h>

#include "dnd.h"
#include "styledbutton.h"
#include "listview.h"
#include "iconview.h"

DnDDemo::DnDDemo( TQWidget* parent, const char* name )
    : DnDDemoBase( parent, name )
{
    buttonPixmap1->setEditor( StyledButton::PixmapEditor );
    buttonPixmap2->setEditor( StyledButton::PixmapEditor );
    buttonPixmap3->setEditor( StyledButton::PixmapEditor );
    buttonPixmap4->setEditor( StyledButton::PixmapEditor );

    multiLine1->setTextFormat( RichText );
    multiLine1->setText( "<p><b>Faust</b> - <i>Goethe</i></p>"
                         "Habe nun, ach! Philosophie,<br>"
			 "Juristerei und Medizin,<br>"
                         "Und leider auch Theologie<br>"
                         "Durchaus studiert, mit heiem Bemhn.<br>"
                         "Da steh ich nun, ich armer Tor!<br>"
                         "Und bin so klug als wie zuvor;<br>"
                         "Heie Magister, heie Doktor gar<br>"
                         "Und ziehe schon an die zehen Jahr<br>"
                         "Herauf, herab und quer und krumm<br>"
                         "Meine Schler an der Nase herum-<br>"
                         "Und sehe, da wir nichts wissen knnen!<br>"
                         "Das will mir schier das Herz verbrennen.<br>"
                         "Zwar bin ich gescheiter als all die Laffen,<br>"
                         "Doktoren, Magister, Schreiber und Pfaffen;<br>"
                         "Mich plagen keine Skrupel noch Zweifel,<br>"
                         "Frchte mich weder vor Hlle noch Teufel-<br>"
                         "Dafr ist mir auch alle Freud entrissen,<br>"
                         "Bilde mir nicht ein, was Rechts zu wissen,<br>"
                         "Bilde mir nicht ein, ich knnte was lehren,<br>"
                         "Die Menschen zu bessern und zu bekehren.<br>"
                         "Auch hab ich weder Gut noch Geld,<br>"
                         "Noch Ehr und Herrlichkeit der Welt;<br>"
                         "Es mchte kein Hund so lnger leben!<br>"
                         "Drum hab ich mich der Magie ergeben,<br>"
                         "Ob mir durch Geistes Kraft und Mund<br>"
                         "Nicht manch Geheimnis wrde kund;<br>"
                         "Da ich nicht mehr mit saurem Schwei<br>"
                         "Zu sagen brauche, was ich nicht wei;<br>"
                         "Da ich erkenne, was die Welt<br>"
                         "Im Innersten zusammenhlt,<br>"
                         "Schau alle Wirkenskraft und Samen,<br>"
                         "Und tu nicht mehr in Worten kramen. <br>" );

    multiLine2->setTextFormat( RichText );
    multiLine2->setText( "<p><b>To Milton</b> - <i>Oscar Wilde</i></p>"
                         "Milton!  I think thy spirit hath passed away<br>"
                         "From these white cliffs and high-embattled towers;<br>"
                         "This gorgeous fiery-coloured world of ours<br>"
                         "Seems fallen into ashes dull and grey,<br>"
                         "And the age changed unto a mimic play<br>"
                         "Wherein we waste our else too-crowded hours:<br>"
                         "For all our pomp and pageantry and powers<br>"
                         "We are but fit to delve the common clay,<br>"
                         "Seeing this little isle on which we stand,<br>"
                         "This England, this sea-lion of the sea,<br>"
                         "By ignorant demagogues is held in fee,<br>"
                         "Who love her not:  Dear God! is this the land<br>"
                         "Which bare a triple empire in her hand<br>"
                         "When Cromwell spake the word Democracy!<br>" );


    items.insert( tr("copy"), IconItem( tr("Copy"), "editcopy.png" ) );
    items.insert( tr("cut"), IconItem( tr("Cut"), "editcut.png" ));
    items.insert( tr("paste"), IconItem( tr("Paste"), "editpaste.png" ));
    items.insert( tr("raise"), IconItem( tr("Raise"), "editraise.png" ));
    items.insert( tr("lower"), IconItem( tr("Lower"), "editlower.png" ));
    items.insert( tr("new"), IconItem( tr("New"), "filenew.png" ));
    items.insert( tr("load"), IconItem( tr("Load"), "fileopen.png" ));
    items.insert( tr("save"), IconItem( tr("Save"), "filesave.png" ));
    items.insert( tr("undo"), IconItem( tr("Undo"), "undo.png" ));
    items.insert( tr("redo"), IconItem( tr("Redo"), "redo.png" ));
    items.insert( tr("delete"), IconItem( tr("Delete"), "editdelete.png" ));
    items.insert( tr("help"), IconItem( tr("Help"), "help.png" ));
    items.insert( tr("home"), IconItem( tr("Home"), "home.png" ));

    listView->addColumn( tr("Actions"), 240 );
    listView->setColumnWidthMode( 0, TQListView::Maximum );

    TQMap<TQString,IconItem>::Iterator it;
    for( it = items.begin(); it != items.end(); ++it ) {
        IconItem item = it.data();

        TQIconViewItem *iitem = new IconViewItem( iconView, item.name(), *item.pixmap(), it.key() );
        iitem->setRenameEnabled( true );
        TQListViewItem *litem = new ListViewItem( listView, item.name(), it.key() );
        litem->setPixmap( 0, *item.pixmap() );
    }
}

DnDDemo::~DnDDemo()
{

}

IconItem::IconItem( const TQString& name, const TQString& icon )
{
    _name = name;
    _pixmap = loadPixmap( icon );
}

TQPixmap IconItem::loadPixmap( const TQString& name )
{
    TQPixmap pix( "textdrawing/" + name );
    return pix;
}

IconItem DnDDemo::findItem( const TQString& tag )
{
    return items[ tag ];
}
