/****************************************************************************
** $Id: application.cpp,v 1.1 2004/09/18 17:31:23 phil Exp $
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include "application.h"

#include <tqimage.h>
#include <tqpixmap.h>
#include <tqtoolbar.h>
#include <tqtoolbutton.h>
#include <tqpopupmenu.h>
#include <tqmenubar.h>
#include <tqfile.h>
#include <tqfiledialog.h>
#include <tqstatusbar.h>
#include <tqmessagebox.h>
#include <tqprinter.h>
#include <tqapplication.h>
#include <tqaccel.h>
#include <tqtextstream.h>
#include <tqpainter.h>
#include <tqpaintdevicemetrics.h>
#include <tqwhatsthis.h>
#include <tqsimplerichtext.h>

#include <tqextscintilla.h>
#include <tqextscintillaprinter.h>

#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"

ApplicationWindow::ApplicationWindow()
    : TQMainWindow( 0, "example application main window", WDestructiveClose | WGroupLeader )
{
    printer = new TQextScintillaPrinter( TQPrinter::HighResolution );
    TQPixmap openIcon, saveIcon, printIcon;

    TQToolBar * fileTools = new TQToolBar( this, "file operations" );
    fileTools->setLabel( "File Operations" );

    openIcon = TQPixmap( fileopen );
    TQToolButton * fileOpen
	= new TQToolButton( openIcon, "Open File", TQString(),
			   this, TQ_SLOT(choose()), fileTools, "open file" );

    saveIcon = TQPixmap( filesave );
    TQToolButton * fileSave
	= new TQToolButton( saveIcon, "Save File", TQString(),
			   this, TQ_SLOT(save()), fileTools, "save file" );

    printIcon = TQPixmap( fileprint );
    TQToolButton * filePrint
	= new TQToolButton( printIcon, "Print File", TQString(),
			   this, TQ_SLOT(print()), fileTools, "print file" );


    (void)TQWhatsThis::whatsThisButton( fileTools );

    const char * fileOpenText = "<p><img source=\"fileopen\"> "
	         "Click this button to open a <em>new file</em>.<br>"
                 "You can also select the <b>Open</b> command "
                 "from the <b>File</b> menu.</p>";

    TQWhatsThis::add( fileOpen, fileOpenText );

    TQMimeSourceFactory::defaultFactory()->setPixmap( "document-open", openIcon );

    const char * fileSaveText = "<p>Click this button to save the file you "
                 "are editing. You will be prompted for a file name.\n"
                 "You can also select the <b>Save</b> command "
                 "from the <b>File</b> menu.</p>";

    TQWhatsThis::add( fileSave, fileSaveText );

    const char * filePrintText = "Click this button to print the file you "
                 "are editing.\n"
		 "You can also select the Print command "
		 "from the File menu.";

    TQWhatsThis::add( filePrint, filePrintText );


    TQPopupMenu * file = new TQPopupMenu( this );
    menuBar()->insertItem( "&File", file );


    file->insertItem( "&New", this, TQ_SLOT(newDoc()), CTRL+Key_N );

    int id;
    id = file->insertItem( openIcon, "&Open...",
			   this, TQ_SLOT(choose()), CTRL+Key_O );
    file->setWhatsThis( id, fileOpenText );

    id = file->insertItem( saveIcon, "&Save",
			   this, TQ_SLOT(save()), CTRL+Key_S );
    file->setWhatsThis( id, fileSaveText );

    id = file->insertItem( "Save &As...", this, TQ_SLOT(saveAs()) );
    file->setWhatsThis( id, fileSaveText );

    file->insertSeparator();

    id = file->insertItem( printIcon, "&Print...",
			   this, TQ_SLOT(print()), CTRL+Key_P );
    file->setWhatsThis( id, filePrintText );

    file->insertSeparator();

    file->insertItem( "&Close", this, TQ_SLOT(close()), CTRL+Key_W );

    file->insertItem( "&Quit", tqApp, TQ_SLOT( closeAllWindows() ), CTRL+Key_Q );

    menuBar()->insertSeparator();

    TQPopupMenu * help = new TQPopupMenu( this );
    menuBar()->insertItem( "&Help", help );

    help->insertItem( "&About", this, TQ_SLOT(about()), Key_F1 );
    help->insertItem( "About &TQt", this, TQ_SLOT(aboutTQt()) );
    help->insertSeparator();
    help->insertItem( "What's &This", this, TQ_SLOT(whatsThis()), SHIFT+Key_F1 );

    e = new TQextScintilla( this, "editor" );
    e->setFocus();
    setCentralWidget( e );
    statusBar()->message( "Ready", 2000 );

    resize( 450, 600 );
}


ApplicationWindow::~ApplicationWindow()
{
    delete printer;
}



void ApplicationWindow::newDoc()
{
    ApplicationWindow *ed = new ApplicationWindow;
    ed->setCaption("TQScintilla Example - Application");
    ed->show();
}

void ApplicationWindow::choose()
{
    TQString fn = TQFileDialog::getOpenFileName( TQString(), TQString(),
					       this);
    if ( !fn.isEmpty() )
	load( fn );
    else
	statusBar()->message( "Loading aborted", 2000 );
}


void ApplicationWindow::load( const TQString &fileName )
{
    TQFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
	return;

    TQTextStream ts( &f );
    e->setText( ts.read() );
    e->setModified( false );
    setCaption( fileName );
    statusBar()->message( "Loaded document " + fileName, 2000 );
}


void ApplicationWindow::save()
{
    if ( filename.isEmpty() ) {
	saveAs();
	return;
    }

    TQString text = e->text();
    TQFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
	statusBar()->message( TQString("Could not write to %1").arg(filename),
			      2000 );
	return;
    }

    TQTextStream t( &f );
    t << text;
    f.close();

    e->setModified( false );

    setCaption( filename );

    statusBar()->message( TQString( "File %1 saved" ).arg( filename ), 2000 );
}


void ApplicationWindow::saveAs()
{
    TQString fn = TQFileDialog::getSaveFileName( TQString(), TQString(),
					       this );
    if ( !fn.isEmpty() ) {
	filename = fn;
	save();
    } else {
	statusBar()->message( "Saving aborted", 2000 );
    }
}


void ApplicationWindow::print()
{
    printer->setFullPage( true );
    if ( printer->setup(this) ) {		// printer dialog
	statusBar()->message( "Printing..." );

	if (printer->printRange( e ))
	    statusBar()->message( "Printing completed", 2000 );
	else
	    statusBar()->message( "Error while printing", 2000 );
    } else {
	statusBar()->message( "Printing aborted", 2000 );
    }
}

void ApplicationWindow::closeEvent( TQCloseEvent* ce )
{
    if ( !e->isModified() ) {
	ce->accept();
	return;
    }

    switch( TQMessageBox::information( this, "TQScintilla Application Example",
				      "Do you want to save the changes"
				      " to the document?",
				      "Yes", "No", "Cancel",
				      0, 1 ) ) {
    case 0:
	save();
	ce->accept();
	break;
    case 1:
	ce->accept();
	break;
    case 2:
    default: // just for sanity
	ce->ignore();
	break;
    }
}


void ApplicationWindow::about()
{
    TQMessageBox::about( this, "TQScintilla Application Example",
			"This example demonstrates a simple use of "
			"TQextScintilla and TQextScintillaPrinter.");
}


void ApplicationWindow::aboutTQt()
{
    TQMessageBox::aboutTQt( this, "TQScintilla Application Example" );
}

#include "application.moc"
