/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2002 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt. If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.

**************************************************************************** */
#ifndef TMXCOMPENDIUMDATA_H
#define TMXCOMPENDIUMDATA_H


#include <kurl.h>
#include <tqdict.h>
#include <tqobject.h>
#include <tqstringlist.h>
#include <tqvaluelist.h>
#include <tqvaluevector.h>
#include <tqptrlist.h>

class TmxCompendiumData : public TQObject
{
    TQ_OBJECT
  

public:
    TmxCompendiumData(TQObject *parent=0);

    bool load(const KURL& url, const TQString& language);

    const int *exactDict(const TQString& text) const;
    const TQValueList<int> *allDict(const TQString& text) const;
    const TQValueList<int> *wordDict(const TQString& text) const;
    
    const TQString msgid(const int index) const;
    const TQString msgstr(const int index) const;
    const int numberOfEntries() const { return _exactDict.count(); }

    bool active() const { return _active; }
    bool initialized() const { return _initialized; }
    bool hasErrors() const { return _error; }
    TQString errorMsg() const { return _errorMsg; }

    /** registers an object, that uses this data */
    void registerObject(TQObject *);
    /** 
     * unregisters an object, that uses this data 
     * 
     * @return true, if this was the last object
     */
    bool unregisterObject(TQObject *);

    bool hasObjects() const;


    static TQString simplify(const TQString& text);
    static TQStringList wordList(const TQString& text);
    
signals:
    void progressStarts(const TQString&);
    void progressEnds();
    void progress(int);

    
private:
    bool _active;
    bool _error;
    bool _initialized;
    TQString _errorMsg;

    TQDict<int> _exactDict;
    TQDict< TQValueList<int> > _allDict;
    TQDict< TQValueList<int> > _wordDict;
    
    TQValueVector<TQString> _originals;
    TQValueVector<TQString> _translations;

    TQPtrList<TQObject> _registered;
};

#endif
