/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   rajko.albrecht@tecways.com                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#ifndef _tdesvnd_dcop_H
#define _tdesvnd_dcop_H

#include <tqstringlist.h>
#include <tqstring.h>
#include <kurl.h>
#include <dcopobject.h>
#include <kdedmodule.h>

class IListener;

class tdesvnd_dcop :  public KDEDModule
{
//    TQ_OBJECT
//    
    K_DCOP

private:

public:
    tdesvnd_dcop(const TQCString&);
    virtual ~tdesvnd_dcop();

protected:
    bool isWorkingCopy(const KURL&url,TQString&base);
    bool isRepository(const KURL&url);
    static TQString cleanUrl(const KURL&url);
    IListener*m_Listener;

k_dcop:
    //! get a subversion login
    /*!
    * \param realm the realm
    * \param user default username
    * \return a stringlist containing username-password-saveit as "true" or "false" or empty list if cancel hit.
    */
    TQStringList get_login(TQString,TQString);

    // return: -1 dont accept 0 accept temporary 1 accept always
    //               hostname, fingerprint, validFrom, validUntil, issuerDName, realm,
    int get_sslaccept(TQString, TQString,     TQString,   TQString,    TQString,     TQString);

    // returns cert file or empty string
    TQString get_sslclientcertfile();
    // return a logmessage at pos 0, null-size list if cancel hit
    TQStringList get_logmsg();
    // return a logmessage at pos 0, null-size list if cancel hit, parameter is path -> action for display
    TQStringList get_logmsg(TQMap<TQString,TQString>);
    // return pw at pos 0, maysafe at pos 1, null-size if cancel hit.
    TQStringList get_sslclientcertpw(TQString);
    TQStringList getActionMenu(KURL::List);
    TQStringList getSingleActionMenu(TQCString);
};
#endif
