//////////////////////////////////////////////////////////////////////////
// tagListItem.h                                                        //
//                                                                      //
// Copyright (C)  2005  Lukas Tinkl <lukas@kde.org>                     //
//                                                                      //
// This program is free software; you can redistribute it and/or        //
// modify it under the terms of the GNU General Public License          //
// as published by the Free Software Foundation; either version 2       //
// of the License, or (at your option) any later version.               //
//                                                                      //
// This program is distributed in the hope that it will be useful,      //
// but WITHOUT ANY WARRANTY; without even the implied warranty of       //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        //
// GNU General Public License for more details.                         //
//                                                                      //
// You should have received a copy of the GNU General Public License    //
// along with this program; if not, write to the Free Software          //
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA            //
// 02110-1301, USA.                                                     //
//////////////////////////////////////////////////////////////////////////

#ifndef _TAGLISTITEM_H_
#define _TAGLISTITEM_H_

#include <tqobject.h>
#include <tqlistview.h>

class TagListItem: public TQObject, public TQCheckListItem
{
    TQ_OBJECT
  
public:
    TagListItem( TQListView * parent, const TQString & tagName, int count = 1 );
    int count() const;
    TQString name() const;
    void setName( const TQString & name );

protected:
    virtual void stateChange( bool state );
    virtual int compare( TQListViewItem * i, int col, bool ascending ) const;
    virtual TQString text( int column ) const;

signals:
    void signalItemChecked( TagListItem * );

private:
    TQString m_name;
    int m_count;
};

#endif
